"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRenderErrors = void 0;

var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));

var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const getRenderErrors = async (browser, logger, layout) => {
  const span = _elasticApmNode.default.startSpan('get_render_errors', 'read');

  logger.debug('reading render errors');
  const errorsFound = await browser.evaluate({
    fn: (errorSelector, errorAttribute) => {
      const visualizations = Array.from(document.querySelectorAll(errorSelector));
      const errors = [];
      visualizations.forEach(visualization => {
        const errorMessage = visualization.getAttribute(errorAttribute);

        if (errorMessage) {
          errors.push(errorMessage);
        }
      });
      return errors.length ? errors : undefined;
    },
    args: [layout.selectors.renderError, layout.selectors.renderErrorAttribute]
  }, {
    context: _constants.CONTEXT_GETRENDERERRORS
  }, logger);
  span === null || span === void 0 ? void 0 : span.end();

  if (errorsFound !== null && errorsFound !== void 0 && errorsFound.length) {
    logger.warn(`Found ${errorsFound.length} error messages. See report object for more information.`);
  }

  return errorsFound;
};

exports.getRenderErrors = getRenderErrors;