"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTracker = getTracker;

var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const TRANSACTION_TYPE = 'reporting'; // TODO: Find out whether we can rename to "screenshotting";

const SPANTYPE_OUTPUT = 'output';

function getTracker() {
  const apmTrans = _elasticApmNode.default.startTransaction('generate-pdf', TRANSACTION_TYPE);

  let apmAddImage = null;
  let apmCompilePdf = null;
  return {
    startAddImage() {
      apmAddImage = (apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.startSpan('add-pdf-image', SPANTYPE_OUTPUT)) || null;
    },

    endAddImage() {
      var _apmAddImage;

      (_apmAddImage = apmAddImage) === null || _apmAddImage === void 0 ? void 0 : _apmAddImage.end();
    },

    startCompile() {
      apmCompilePdf = (apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.startSpan('compile-pdf', SPANTYPE_OUTPUT)) || null;
    },

    endCompile() {
      var _apmCompilePdf;

      (_apmCompilePdf = apmCompilePdf) === null || _apmCompilePdf === void 0 ? void 0 : _apmCompilePdf.end();
    },

    setByteLength(byteLength) {
      apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.setLabel('byte-length', byteLength, false);
    },

    end() {
      apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.end();
    }

  };
}