"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
Object.defineProperty(exports, "createConfig", {
  enumerable: true,
  get: function () {
    return _create_config.createConfig;
  }
});

var _schema = require("./schema");

var _create_config = require("./create_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Screenshotting plugin configuration schema.
 */


const config = {
  schema: _schema.ConfigSchema,
  deprecations: ({
    renameFromRoot
  }) => [renameFromRoot('xpack.reporting.capture.networkPolicy', 'xpack.screenshotting.networkPolicy', {
    level: 'warning'
  }), renameFromRoot('xpack.reporting.capture.browser.autoDownload', 'xpack.screenshotting.browser.autoDownload', {
    level: 'warning'
  }), renameFromRoot('xpack.reporting.capture.browser.chromium.inspect', 'xpack.screenshotting.browser.chromium.inspect', {
    level: 'warning'
  }), renameFromRoot('xpack.reporting.capture.browser.chromium.disableSandbox', 'xpack.screenshotting.browser.chromium.disableSandbox', {
    level: 'warning'
  }), renameFromRoot('xpack.reporting.capture.browser.chromium.proxy.enabled', 'xpack.screenshotting.browser.chromium.proxy.enabled', {
    level: 'warning'
  }), renameFromRoot('xpack.reporting.capture.browser.chromium.proxy.server', 'xpack.screenshotting.browser.chromium.proxy.server', {
    level: 'warning'
  }), renameFromRoot('xpack.reporting.capture.browser.chromium.proxy.bypass', 'xpack.screenshotting.browser.chromium.proxy.bypass', {
    level: 'warning'
  })],
  exposeToUsage: {
    networkPolicy: false // show as [redacted]

  }
};
exports.config = config;