"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UI_SETTING_MAX_FILE_SIZE = exports.MB = exports.MAX_FILE_SIZE_BYTES = exports.MAX_FILE_SIZE = exports.INDEX_META_DATA_CREATED_BY = exports.FILE_SIZE_DISPLAY_FORMAT = exports.FILE_FORMATS = exports.ABSOLUTE_MAX_FILE_SIZE_BYTES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UI_SETTING_MAX_FILE_SIZE = 'fileUpload:maxFileSize';
exports.UI_SETTING_MAX_FILE_SIZE = UI_SETTING_MAX_FILE_SIZE;
const MB = Math.pow(2, 20);
exports.MB = MB;
const MAX_FILE_SIZE = '100MB';
exports.MAX_FILE_SIZE = MAX_FILE_SIZE;
const MAX_FILE_SIZE_BYTES = 104857600; // 100MB

exports.MAX_FILE_SIZE_BYTES = MAX_FILE_SIZE_BYTES;
const ABSOLUTE_MAX_FILE_SIZE_BYTES = 1073741274; // 1GB

exports.ABSOLUTE_MAX_FILE_SIZE_BYTES = ABSOLUTE_MAX_FILE_SIZE_BYTES;
const FILE_SIZE_DISPLAY_FORMAT = '0,0.[0] b'; // Value to use in the Elasticsearch index mapping meta data to identify the
// index as having been created by the ML File Data Visualizer.

exports.FILE_SIZE_DISPLAY_FORMAT = FILE_SIZE_DISPLAY_FORMAT;
const INDEX_META_DATA_CREATED_BY = 'file-data-visualizer';
exports.INDEX_META_DATA_CREATED_BY = INDEX_META_DATA_CREATED_BY;
const FILE_FORMATS = {
  DELIMITED: 'delimited',
  NDJSON: 'ndjson',
  SEMI_STRUCTURED_TEXT: 'semi_structured_text' // XML: 'xml',

};
exports.FILE_FORMATS = FILE_FORMATS;