"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeCspRules = void 0;

var _rules = require("./cis_1_4_1/rules");

var _csp_rule = require("../../common/schemas/csp_rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const initializeCspRules = async client => {
  const existingRules = await client.find({
    type: _csp_rule.cspRuleAssetSavedObjectType,
    perPage: 1
  }); // TODO: version?

  if (existingRules.total !== 0) return;

  try {
    await client.bulkCreate(_rules.CIS_BENCHMARK_1_4_1_RULES);
  } catch (e) {// TODO: add logger
    // TODO: handle error
  }
};

exports.initializeCspRules = initializeCspRules;