"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExecutionConfigForRuleType = void 0;

var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const getExecutionConfigForRuleType = ({
  config,
  ruleTypeId
}) => {
  var _config$run$ruleTypeO;

  const ruleTypeExecutionConfig = (_config$run$ruleTypeO = config.run.ruleTypeOverrides) === null || _config$run$ruleTypeO === void 0 ? void 0 : _config$run$ruleTypeO.find(ruleType => ruleType.id === ruleTypeId);
  return {
    run: { ...(0, _lodash.omit)(config.run, 'ruleTypeOverrides'),
      ...ruleTypeExecutionConfig
    }
  };
};

exports.getExecutionConfigForRuleType = getExecutionConfigForRuleType;