"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.yAxisConfigFunction = void 0;

var _i18n = require("@kbn/i18n");

var _constants = require("../constants");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const yAxisConfigFunction = {
  name: _constants.Y_CONFIG,
  aliases: [],
  type: _constants.Y_CONFIG,
  help: _i18n.i18n.translate('expressionXY.yConfig.help', {
    defaultMessage: `Configure the behavior of a xy chart's y axis metric`
  }),
  inputTypes: ['null'],
  args: {
    forAccessor: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.yConfig.forAccessor.help', {
        defaultMessage: 'The accessor this configuration is for'
      })
    },
    axisMode: {
      types: ['string'],
      options: [...Object.values(_constants.YAxisModes)],
      help: _i18n.i18n.translate('expressionXY.yConfig.axisMode.help', {
        defaultMessage: 'The axis mode of the metric'
      })
    },
    color: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.yConfig.color.help', {
        defaultMessage: 'The color of the series'
      })
    },
    lineStyle: {
      types: ['string'],
      options: [...Object.values(_constants.LineStyles)],
      help: _i18n.i18n.translate('expressionXY.yConfig.lineStyle.help', {
        defaultMessage: 'The style of the reference line'
      })
    },
    lineWidth: {
      types: ['number'],
      help: _i18n.i18n.translate('expressionXY.yConfig.lineWidth.help', {
        defaultMessage: 'The width of the reference line'
      })
    },
    icon: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.yConfig.icon.help', {
        defaultMessage: 'An optional icon used for reference lines'
      })
    },
    iconPosition: {
      types: ['string'],
      options: [...Object.values(_constants.IconPositions)],
      help: _i18n.i18n.translate('expressionXY.yConfig.iconPosition.help', {
        defaultMessage: 'The placement of the icon for the reference line'
      })
    },
    textVisibility: {
      types: ['boolean'],
      help: _i18n.i18n.translate('expressionXY.yConfig.textVisibility.help', {
        defaultMessage: 'Visibility of the label on the reference line'
      })
    },
    fill: {
      types: ['string'],
      options: [...Object.values(_constants.FillStyles)],
      help: _i18n.i18n.translate('expressionXY.yConfig.fill.help', {
        defaultMessage: 'Fill'
      })
    }
  },

  fn(input, args) {
    return {
      type: _constants.Y_CONFIG,
      ...args
    };
  }

};
exports.yAxisConfigFunction = yAxisConfigFunction;