"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.xyVisFunction = void 0;

var _i18n = require("@kbn/i18n");

var _utils = require("../../../../../../src/plugins/visualizations/common/utils");

var _constants = require("../constants");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const strings = {
  getMetricHelp: () => _i18n.i18n.translate('expressionXY.xyVis.logDatatable.metric', {
    defaultMessage: 'Vertical axis'
  }),
  getXAxisHelp: () => _i18n.i18n.translate('expressionXY.xyVis.logDatatable.x', {
    defaultMessage: 'Horizontal axis'
  }),
  getBreakdownHelp: () => _i18n.i18n.translate('expressionXY.xyVis.logDatatable.breakDown', {
    defaultMessage: 'Break down by'
  }),
  getReferenceLineHelp: () => _i18n.i18n.translate('expressionXY.xyVis.logDatatable.breakDown', {
    defaultMessage: 'Break down by'
  })
};
const xyVisFunction = {
  name: _constants.XY_VIS,
  type: 'render',
  inputTypes: [_constants.MULTITABLE],
  help: _i18n.i18n.translate('expressionXY.xyVis.help', {
    defaultMessage: 'An X/Y chart'
  }),
  args: {
    title: {
      types: ['string'],
      help: 'The chart title.'
    },
    description: {
      types: ['string'],
      help: ''
    },
    xTitle: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.xyVis.xTitle.help', {
        defaultMessage: 'X axis title'
      })
    },
    yTitle: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.xyVis.yLeftTitle.help', {
        defaultMessage: 'Y left axis title'
      })
    },
    yRightTitle: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.xyVis.yRightTitle.help', {
        defaultMessage: 'Y right axis title'
      })
    },
    yLeftExtent: {
      types: [_constants.AXIS_EXTENT_CONFIG],
      help: _i18n.i18n.translate('expressionXY.xyVis.yLeftExtent.help', {
        defaultMessage: 'Y left axis extents'
      })
    },
    yRightExtent: {
      types: [_constants.AXIS_EXTENT_CONFIG],
      help: _i18n.i18n.translate('expressionXY.xyVis.yRightExtent.help', {
        defaultMessage: 'Y right axis extents'
      })
    },
    legend: {
      types: [_constants.LEGEND_CONFIG],
      help: _i18n.i18n.translate('expressionXY.xyVis.legend.help', {
        defaultMessage: 'Configure the chart legend.'
      })
    },
    fittingFunction: {
      types: ['string'],
      options: [...Object.values(_constants.FittingFunctions)],
      help: _i18n.i18n.translate('expressionXY.xyVis.fittingFunction.help', {
        defaultMessage: 'Define how missing values are treated'
      })
    },
    endValue: {
      types: ['string'],
      options: [...Object.values(_constants.EndValues)],
      help: _i18n.i18n.translate('expressionXY.xyVis.endValue.help', {
        defaultMessage: 'End value'
      })
    },
    emphasizeFitting: {
      types: ['boolean'],
      default: false,
      help: ''
    },
    valueLabels: {
      types: ['string'],
      options: [...Object.values(_constants.ValueLabelModes)],
      help: _i18n.i18n.translate('expressionXY.xyVis.valueLabels.help', {
        defaultMessage: 'Value labels mode'
      })
    },
    tickLabelsVisibilitySettings: {
      types: [_constants.TICK_LABELS_CONFIG],
      help: _i18n.i18n.translate('expressionXY.xyVis.tickLabelsVisibilitySettings.help', {
        defaultMessage: 'Show x and y axes tick labels'
      })
    },
    labelsOrientation: {
      types: [_constants.LABELS_ORIENTATION_CONFIG],
      help: _i18n.i18n.translate('expressionXY.xyVis.labelsOrientation.help', {
        defaultMessage: 'Defines the rotation of the axis labels'
      })
    },
    gridlinesVisibilitySettings: {
      types: [_constants.GRID_LINES_CONFIG],
      help: _i18n.i18n.translate('expressionXY.xyVis.gridlinesVisibilitySettings.help', {
        defaultMessage: 'Show x and y axes gridlines'
      })
    },
    axisTitlesVisibilitySettings: {
      types: [_constants.AXIS_TITLES_VISIBILITY_CONFIG],
      help: _i18n.i18n.translate('expressionXY.xyVis.axisTitlesVisibilitySettings.help', {
        defaultMessage: 'Show x and y axes titles'
      })
    },
    layers: {
      types: [_constants.DATA_LAYER, _constants.REFERENCE_LINE_LAYER, _constants.ANNOTATION_LAYER],
      help: _i18n.i18n.translate('expressionXY.xyVis.layers.help', {
        defaultMessage: 'Layers of visual series'
      }),
      multi: true
    },
    curveType: {
      types: ['string'],
      options: [...Object.values(_constants.XYCurveTypes)],
      help: _i18n.i18n.translate('expressionXY.xyVis.curveType.help', {
        defaultMessage: 'Define how curve type is rendered for a line chart'
      })
    },
    fillOpacity: {
      types: ['number'],
      help: _i18n.i18n.translate('expressionXY.xyVis.fillOpacity.help', {
        defaultMessage: 'Define the area chart fill opacity'
      })
    },
    hideEndzones: {
      types: ['boolean'],
      default: false,
      help: _i18n.i18n.translate('expressionXY.xyVis.hideEndzones.help', {
        defaultMessage: 'Hide endzone markers for partial data'
      })
    },
    valuesInLegend: {
      types: ['boolean'],
      default: false,
      help: _i18n.i18n.translate('expressionXY.xyVis.valuesInLegend.help', {
        defaultMessage: 'Show values in legend'
      })
    },
    ariaLabel: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.xyVis.ariaLabel.help', {
        defaultMessage: 'Specifies the aria label of the xy chart'
      }),
      required: false
    }
  },

  fn(data, args, handlers) {
    var _handlers$inspectorAd, _ref, _args$ariaLabel, _handlers$variables, _handlers$getExecutio, _handlers$getExecutio2;

    if (handlers !== null && handlers !== void 0 && (_handlers$inspectorAd = handlers.inspectorAdapters) !== null && _handlers$inspectorAd !== void 0 && _handlers$inspectorAd.tables) {
      args.layers.forEach(layer => {
        if (layer.layerType === _constants.LayerTypes.ANNOTATIONS) {
          return;
        }

        let xAccessor;
        let splitAccessor;

        if (layer.layerType === _constants.LayerTypes.DATA) {
          xAccessor = layer.xAccessor;
          splitAccessor = layer.splitAccessor;
        }

        const {
          layerId,
          accessors,
          layerType
        } = layer;
        const logTable = (0, _utils.prepareLogTable)(data.tables[layerId], [[accessors ? accessors : undefined, layerType === 'data' ? strings.getMetricHelp() : strings.getReferenceLineHelp()], [xAccessor ? [xAccessor] : undefined, strings.getXAxisHelp()], [splitAccessor ? [splitAccessor] : undefined, strings.getBreakdownHelp()]], true);
        handlers.inspectorAdapters.tables.logDatatable(layerId, logTable);
      });
    }

    return {
      type: 'render',
      as: _constants.XY_VIS_RENDERER,
      value: {
        data,
        args: { ...args,
          ariaLabel: (_ref = (_args$ariaLabel = args.ariaLabel) !== null && _args$ariaLabel !== void 0 ? _args$ariaLabel : (_handlers$variables = handlers.variables) === null || _handlers$variables === void 0 ? void 0 : _handlers$variables.embeddableTitle) !== null && _ref !== void 0 ? _ref : (_handlers$getExecutio = handlers.getExecutionContext) === null || _handlers$getExecutio === void 0 ? void 0 : (_handlers$getExecutio2 = _handlers$getExecutio.call(handlers)) === null || _handlers$getExecutio2 === void 0 ? void 0 : _handlers$getExecutio2.description
        }
      }
    };
  }

};
exports.xyVisFunction = xyVisFunction;