"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataLayerConfigFunction = void 0;

var _i18n = require("@kbn/i18n");

var _constants = require("../constants");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const dataLayerConfigFunction = {
  name: _constants.DATA_LAYER,
  aliases: [],
  type: _constants.DATA_LAYER,
  help: _i18n.i18n.translate('expressionXY.dataLayer.help', {
    defaultMessage: `Configure a layer in the xy chart`
  }),
  inputTypes: ['null'],
  args: {
    hide: {
      types: ['boolean'],
      default: false,
      help: _i18n.i18n.translate('expressionXY.dataLayer.hide.help', {
        defaultMessage: 'Show / hide axis'
      })
    },
    layerId: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.dataLayer.layerId.help', {
        defaultMessage: 'Layer ID'
      })
    },
    xAccessor: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.dataLayer.xAccessor.help', {
        defaultMessage: 'X-axis'
      })
    },
    seriesType: {
      types: ['string'],
      options: [...Object.values(_constants.SeriesTypes)],
      help: _i18n.i18n.translate('expressionXY.dataLayer.seriesType.help', {
        defaultMessage: 'The type of chart to display.'
      })
    },
    xScaleType: {
      options: [...Object.values(_constants.XScaleTypes)],
      help: _i18n.i18n.translate('expressionXY.dataLayer.xScaleType.help', {
        defaultMessage: 'The scale type of the x axis'
      }),
      default: _constants.XScaleTypes.ORDINAL
    },
    isHistogram: {
      types: ['boolean'],
      default: false,
      help: _i18n.i18n.translate('expressionXY.dataLayer.isHistogram.help', {
        defaultMessage: 'Whether to layout the chart as a histogram'
      })
    },
    yScaleType: {
      options: [...Object.values(_constants.YScaleTypes)],
      help: _i18n.i18n.translate('expressionXY.dataLayer.yScaleType.help', {
        defaultMessage: 'The scale type of the y axes'
      }),
      default: _constants.YScaleTypes.LINEAR
    },
    splitAccessor: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.dataLayer.splitAccessor.help', {
        defaultMessage: 'The column to split by'
      })
    },
    accessors: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.dataLayer.accessors.help', {
        defaultMessage: 'The columns to display on the y axis.'
      }),
      multi: true
    },
    yConfig: {
      types: [_constants.Y_CONFIG],
      help: _i18n.i18n.translate('expressionXY.dataLayer.yConfig.help', {
        defaultMessage: 'Additional configuration for y axes'
      }),
      multi: true
    },
    columnToLabel: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.dataLayer.columnToLabel.help', {
        defaultMessage: 'JSON key-value pairs of column ID to label'
      })
    },
    palette: {
      types: ['palette', 'system_palette'],
      help: _i18n.i18n.translate('expressionXY.dataLayer.palette.help', {
        defaultMessage: 'Palette'
      }),
      default: '{palette}'
    }
  },

  fn(input, args) {
    return {
      type: _constants.DATA_LAYER,
      ...args,
      layerType: _constants.LayerTypes.DATA
    };
  }

};
exports.dataLayerConfigFunction = dataLayerConfigFunction;