"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.axisExtentConfigFunction = void 0;

var _i18n = require("@kbn/i18n");

var _constants = require("../constants");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const axisExtentConfigFunction = {
  name: _constants.AXIS_EXTENT_CONFIG,
  aliases: [],
  type: _constants.AXIS_EXTENT_CONFIG,
  help: _i18n.i18n.translate('expressionXY.axisExtentConfig.help', {
    defaultMessage: `Configure the xy chart's axis extents`
  }),
  inputTypes: ['null'],
  args: {
    mode: {
      types: ['string'],
      options: [...Object.values(_constants.AxisExtentModes)],
      help: _i18n.i18n.translate('expressionXY.axisExtentConfig.extentMode.help', {
        defaultMessage: 'The extent mode'
      })
    },
    lowerBound: {
      types: ['number'],
      help: _i18n.i18n.translate('expressionXY.axisExtentConfig.lowerBound.help', {
        defaultMessage: 'Lower bound'
      })
    },
    upperBound: {
      types: ['number'],
      help: _i18n.i18n.translate('expressionXY.axisExtentConfig.upperBound.help', {
        defaultMessage: 'Upper bound'
      })
    }
  },

  fn(input, args) {
    return {
      type: _constants.AXIS_EXTENT_CONFIG,
      ...args
    };
  }

};
exports.axisExtentConfigFunction = axisExtentConfigFunction;