import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { getGeneralFilters } from '../get_general_filters';
import { getSavedObjectTypes } from '../get_saved_object_types';
export var getFilters = function getFilters(_ref) {
  var filters = _ref.filters,
      namespaceTypes = _ref.namespaceTypes,
      hideLists = _ref.hideLists;
  var namespaces = getSavedObjectTypes({
    namespaceType: namespaceTypes
  });
  var generalFilters = getGeneralFilters(filters, namespaces);
  var hideListsFilters = hideLists.map(function (listId) {
    var filtersByNamespace = namespaces.map(function (namespace) {
      return "not ".concat(namespace, ".attributes.list_id: ").concat(listId, "*");
    });
    return "(".concat(filtersByNamespace.join(' AND '), ")");
  });
  return [generalFilters].concat(_toConsumableArray(hideListsFilters)).filter(function (filter) {
    return filter.trim() !== '';
  }).join(' AND ');
};