/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { EmptyStringArray, NonEmptyStringArray, StringToPositiveNumber } from '@kbn/securitysolution-io-ts-types';
import { DefaultNamespaceArray } from '../../common/default_namespace_array';
import { sort_field } from '../../common/sort_field';
import { sort_order } from '../../common/sort_order';
export var findExceptionListItemSchema = t.intersection([t.exact(t.type({
  list_id: NonEmptyStringArray
})), t.exact(t.partial({
  filter: EmptyStringArray,
  // defaults to an empty array [] if not set during decode
  namespace_type: DefaultNamespaceArray,
  // defaults to ['single'] if not set during decode
  page: StringToPositiveNumber,
  // defaults to undefined if not set during decode
  per_page: StringToPositiveNumber,
  // defaults to undefined if not set during decode
  sort_field: sort_field,
  // defaults to undefined if not set during decode
  sort_order: sort_order // defaults to undefined if not set during decode

}))]);