/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { DefaultUuid, DefaultVersionNumber } from '@kbn/securitysolution-io-ts-types';
import { exceptionListType } from '../../common/exception_list';
import { osTypeArrayOrUndefined } from '../../common/os_type';
import { name } from '../../common/name';
import { description } from '../../common/description';
import { namespace_type } from '../../common/namespace_type';
import { tags } from '../../common/tags';
import { meta } from '../../common/meta';
export var createExceptionListSchema = t.intersection([t.exact(t.type({
  description: description,
  name: name,
  type: exceptionListType
})), t.exact(t.partial({
  list_id: DefaultUuid,
  // defaults to a GUID (UUID v4) string if not set during decode
  meta: meta,
  // defaults to undefined if not set during decode
  namespace_type: namespace_type,
  // defaults to 'single' if not set during decode
  os_types: osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: tags,
  // defaults to empty array if not set during decode
  version: DefaultVersionNumber // defaults to numerical 1 if not set during decode

}))]);