"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.importExceptionsResponseSchema = exports.bulkErrorSchema = exports.bulkErrorErrorSchema = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");

var _id = require("../../common/id");

var _list_id = require("../../common/list_id");

var _item_id = require("../../common/item_id");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const bulkErrorErrorSchema = t.exact(t.type({
  status_code: t.number,
  message: t.string
}));
exports.bulkErrorErrorSchema = bulkErrorErrorSchema;
const bulkErrorSchema = t.intersection([t.exact(t.type({
  error: bulkErrorErrorSchema
})), t.partial({
  id: _id.id,
  list_id: _list_id.list_id,
  item_id: _item_id.item_id
})]);
exports.bulkErrorSchema = bulkErrorSchema;
const importExceptionsResponseSchema = t.exact(t.type({
  errors: t.array(bulkErrorSchema),
  success: t.boolean,
  success_count: _securitysolutionIoTsTypes.PositiveInteger,
  success_exception_lists: t.boolean,
  success_count_exception_lists: _securitysolutionIoTsTypes.PositiveInteger,
  success_exception_list_items: t.boolean,
  success_count_exception_list_items: _securitysolutionIoTsTypes.PositiveInteger
}));
exports.importExceptionsResponseSchema = importExceptionsResponseSchema;