"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.importExceptionListItemSchema = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _os_type = require("../../common/os_type");

var _name = require("../../common/name");

var _description = require("../../common/description");

var _namespace_type = require("../../common/namespace_type");

var _tags = require("../../common/tags");

var _meta = require("../../common/meta");

var _list_id = require("../../common/list_id");

var _item_id = require("../../common/item_id");

var _id = require("../../common/id");

var _created_at = require("../../common/created_at");

var _created_by = require("../../common/created_by");

var _updated_at = require("../../common/updated_at");

var _updated_by = require("../../common/updated_by");

var _underscore_version = require("../../common/underscore_version");

var _tie_breaker_id = require("../../common/tie_breaker_id");

var _non_empty_entries_array = require("../../common/non_empty_entries_array");

var _exception_list_item_type = require("../../common/exception_list_item_type");

var _default_import_comments_array = require("../../common/default_import_comments_array");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Differences from this and the createExceptionsListItemSchema are
 *   - item_id is required
 *   - id is optional (but ignored in the import code - item_id is exclusively used for imports)
 *   - immutable is optional but if it is any value other than false it will be rejected
 *   - created_at is optional (but ignored in the import code)
 *   - updated_at is optional (but ignored in the import code)
 *   - created_by is optional (but ignored in the import code)
 *   - updated_by is optional (but ignored in the import code)
 */
const importExceptionListItemSchema = t.intersection([t.exact(t.type({
  description: _description.description,
  entries: _non_empty_entries_array.nonEmptyEntriesArray,
  item_id: _item_id.item_id,
  list_id: _list_id.list_id,
  name: _name.name,
  type: _exception_list_item_type.exceptionListItemType
})), t.exact(t.partial({
  id: _id.id,
  // defaults to undefined if not set during decode
  comments: _default_import_comments_array.DefaultImportCommentsArray,
  // defaults to empty array if not set during decode
  created_at: _created_at.created_at,
  // defaults undefined if not set during decode
  updated_at: _updated_at.updated_at,
  // defaults undefined if not set during decode
  created_by: _created_by.created_by,
  // defaults undefined if not set during decode
  updated_by: _updated_by.updated_by,
  // defaults undefined if not set during decode
  _version: _underscore_version._version,
  // defaults to undefined if not set during decode
  tie_breaker_id: _tie_breaker_id.tie_breaker_id,
  meta: _meta.meta,
  // defaults to undefined if not set during decode
  namespace_type: _namespace_type.namespace_type,
  // defaults to 'single' if not set during decode
  os_types: _os_type.osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: _tags.tags // defaults to empty array if not set during decode

}))]);
exports.importExceptionListItemSchema = importExceptionListItemSchema;