"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deepExactRt = deepExactRt;

var t = _interopRequireWildcard(require("io-ts"));

var _lodash = require("lodash");

var _merge_rt = require("../merge_rt");

var _parseable_types = require("../parseable_types");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function deepExactRt(type) {
  if (!(0, _parseable_types.isParsableType)(type)) {
    return type;
  }

  switch (type._tag) {
    case 'ArrayType':
      return t.array(deepExactRt(type.type));

    case 'DictionaryType':
      return t.dictionary(type.domain, deepExactRt(type.codomain));

    case 'InterfaceType':
      return t.exact(t.interface((0, _lodash.mapValues)(type.props, deepExactRt)));

    case 'PartialType':
      return t.exact(t.partial((0, _lodash.mapValues)(type.props, deepExactRt)));

    case 'IntersectionType':
      return t.intersection(type.types.map(deepExactRt));

    case 'UnionType':
      return t.union(type.types.map(deepExactRt));

    case 'MergeType':
      return (0, _merge_rt.mergeRt)(deepExactRt(type.types[0]), deepExactRt(type.types[1]));

    default:
      return type;
  }
}