"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiGlobalStyles = void 0;

var _objectDestructuringEmpty2 = _interopRequireDefault(require("@babel/runtime/helpers/objectDestructuringEmpty"));

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@emotion/react");

var _helpers = require("../mixins/_helpers");

var _color = require("../../services/color");

var _theme = require("../../services/theme");

var _reset = require("./reset");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiGlobalStyles = function EuiGlobalStyles(_ref) {
  (0, _objectDestructuringEmpty2.default)(_ref);

  var _useEuiTheme = (0, _theme.useEuiTheme)(),
      _useEuiTheme$euiTheme = _useEuiTheme.euiTheme,
      base = _useEuiTheme$euiTheme.base,
      border = _useEuiTheme$euiTheme.border,
      colors = _useEuiTheme$euiTheme.colors,
      font = _useEuiTheme$euiTheme.font,
      colorMode = _useEuiTheme.colorMode;
  /**
   * Declaring the top level scrollbar colors to match the theme also requires setting the sizes on Chrome
   * so that it knows to use custom styles. Therefore, we just reuse the same scrollbar mixin with thick size.
   */


  var scrollbarStyles = (0, _helpers.useScrollBar)({
    trackColor: colorMode === 'LIGHT' ? (0, _color.shade)(colors.body, 0.03) : (0, _color.tint)(colors.body, 0.07),
    width: 'auto'
  });
  /**
   * This font reset sets all our base font/typography related properties
   * that are needed to override browser-specific element settings.
   */

  var fontReset = "\n    font-family: ".concat(font.family, ";\n    font-size: ", "".concat(font.scale[font.body.scale] * base, "px"), ";\n    line-height: ").concat(base / (font.scale[font.body.scale] * base), ";\n    font-weight: ").concat(font.weight[font.body.weight], ";\n    ").concat(font.body.letterSpacing ? "letter-spacing: ".concat(font.body.letterSpacing, ";") : '', "\n  ");
  /**
   * Outline/Focus state resets
   */

  var focusReset = function focusReset() {
    // The latest theme utilizes `focus-visible` to turn on focus outlines.
    // But this is browser-dependend:
    // 👉 Safari and Firefox innately respect only showing the outline with keyboard only
    // 💔 But they don't allow coloring of the 'auto'/default outline, so contrast is no good in dark mode.
    // 👉 For these browsers we use the solid type in order to match with \`currentColor\`.
    // 😦 Which does means the outline will be square
    return "*:focus {\n      outline: currentColor solid ".concat(border.width.thick, ";\n      outline-offset: calc(-(").concat(border.width.thick, " / 2) * -1);\n\n      // \uD83D\uDC40 Chrome respects :focus-visible and allows coloring the `auto` style\n      &:focus-visible {\n        outline-style: auto;\n      }\n\n      // \uD83D\uDE45\u200D\u2640\uFE0F But Chrome also needs to have the outline forcefully removed from regular `:focus` state\n      &:not(:focus-visible) {\n        outline: none;\n      }\n    }\n\n    // Dark mode's highlighted doesn't work well so lets just set it the same as our focus background\n    ::selection {\n      background: ").concat((0, _color.transparentize)(colors.primary, colorMode === 'LIGHT' ? 0.1 : 0.2), "\n    }");
  };
  /**
   * Final styles
   */


  var styles = /*#__PURE__*/(0, _react2.css)(_reset.resetStyles, " html{", scrollbarStyles, " ", fontReset, " text-size-adjust:100%;font-kerning:normal;height:100%;background-color:", colors.body, ";color:", colors.text, ";}code,pre,kbd,samp{font-family:", font.familyCode, ";}input,textarea,select{", fontReset, ";}button{font-family:", font.family, ";}em{font-style:italic;}strong{font-weight:", font.weight.bold, ";}", focusReset(), " a{color:", colors.primaryText, ";&,&:hover,&:focus{text-decoration:none;}};label:styles;" + (process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
  return (0, _react2.jsx)(_react2.Global, {
    styles: styles
  });
};

exports.EuiGlobalStyles = EuiGlobalStyles;