"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTour = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _useEuiTour3 = require("./useEuiTour");

var _propTypes = _interopRequireDefault(require("prop-types"));

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiTour = function EuiTour(_ref) {
  var children = _ref.children,
      steps = _ref.steps,
      initialState = _ref.initialState;

  var _useEuiTour = (0, _useEuiTour3.useEuiTour)(steps, initialState),
      _useEuiTour2 = (0, _slicedToArray2.default)(_useEuiTour, 3),
      stepProps = _useEuiTour2[0],
      actions = _useEuiTour2[1],
      state = _useEuiTour2[2];

  return children(stepProps, actions, state);
};

exports.EuiTour = EuiTour;
EuiTour.propTypes = {
  children: _propTypes.default.func.isRequired,
  steps: _propTypes.default.arrayOf(_propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
         * Element to which the tour step popover attaches when open
         */
    children: _propTypes.default.element,
    anchor: _propTypes.default.any,

    /**
         * Contents of the tour step popover
         */
    content: _propTypes.default.node.isRequired,

    /**
         * Step will display if set to `true`
         */
    isStepOpen: _propTypes.default.bool,

    /**
         * Change the default min width of the popover panel
         */
    minWidth: _propTypes.default.any,

    /**
         * Change the default max width of the popover panel
         */
    maxWidth: _propTypes.default.any,

    /**
         * Function to call for 'Skip tour' and 'End tour' actions
         */
    onFinish: _propTypes.default.func.isRequired,

    /**
         * The number of the step within the parent tour. 1-based indexing.
         */
    step: _propTypes.default.number.isRequired,

    /**
         * The total number of steps in the tour
         */
    stepsTotal: _propTypes.default.number.isRequired,

    /**
         * Optional, standard DOM `style` attribute. Passed to the EuiPopover panel.
         */
    style: _propTypes.default.any,

    /**
         * Smaller title text that appears atop each step in the tour. The subtitle gets wrapped in the appropriate heading level.
         */
    subtitle: _propTypes.default.node,

    /**
         * Larger title text specific to this step. The title gets wrapped in the appropriate heading level.
         */
    title: _propTypes.default.node.isRequired,

    /**
         * Extra visual indication of step location
         */
    decoration: _propTypes.default.oneOf(["none", "beacon"]),

    /**
         * Element to replace the 'Skip tour' link in the footer
         */
    footerAction: _propTypes.default.element
  }).isRequired).isRequired,
  initialState: _propTypes.default.shape({
    currentTourStep: _propTypes.default.number.isRequired,
    isTourActive: _propTypes.default.bool.isRequired,
    tourPopoverWidth: _propTypes.default.number.isRequired,
    tourSubtitle: _propTypes.default.string.isRequired
  }).isRequired
};