"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelectableListItem = exports.PADDING_SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireWildcard(require("react"));

var _common = require("../../common");

var _i18n = require("../../i18n");

var _icon = require("../../icon");

var _accessibility = require("../../accessibility");

var _badge = require("../../badge");

var _react2 = require("@emotion/react");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function resolveIconAndColor(checked) {
  if (!checked) {
    return {
      icon: 'empty'
    };
  }

  return checked === 'on' ? {
    icon: 'check',
    color: 'text'
  } : {
    icon: 'cross',
    color: 'text'
  };
}

var paddingSizeToClassNameMap = {
  none: null,
  s: 'euiSelectableListItem--paddingSmall'
};
var PADDING_SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);
exports.PADDING_SIZES = PADDING_SIZES;

// eslint-disable-next-line react/prefer-stateless-function
var EuiSelectableListItem = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiSelectableListItem, _Component);

  var _super = _createSuper(EuiSelectableListItem);

  function EuiSelectableListItem(props) {
    (0, _classCallCheck2.default)(this, EuiSelectableListItem);
    return _super.call(this, props);
  }

  (0, _createClass2.default)(EuiSelectableListItem, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          disabled = _this$props.disabled,
          checked = _this$props.checked,
          isFocused = _this$props.isFocused,
          showIcons = _this$props.showIcons,
          prepend = _this$props.prepend,
          append = _this$props.append,
          allowExclusions = _this$props.allowExclusions,
          onFocusBadge = _this$props.onFocusBadge,
          _this$props$paddingSi = _this$props.paddingSize,
          paddingSize = _this$props$paddingSi === void 0 ? 's' : _this$props$paddingSi,
          _this$props$role = _this$props.role,
          role = _this$props$role === void 0 ? 'option' : _this$props$role,
          searchable = _this$props.searchable,
          textWrap = _this$props.textWrap,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "className", "disabled", "checked", "isFocused", "showIcons", "prepend", "append", "allowExclusions", "onFocusBadge", "paddingSize", "role", "searchable", "textWrap"]);
      var classes = (0, _classnames.default)('euiSelectableListItem', {
        'euiSelectableListItem-isFocused': isFocused
      }, paddingSizeToClassNameMap[paddingSize], className);
      var textClasses = (0, _classnames.default)('euiSelectableListItem__text', (0, _defineProperty2.default)({}, "euiSelectableListItem__text--".concat(textWrap), textWrap));
      var optionIcon;

      if (showIcons) {
        var _resolveIconAndColor = resolveIconAndColor(checked),
            icon = _resolveIconAndColor.icon,
            color = _resolveIconAndColor.color;

        optionIcon = (0, _react2.jsx)(_icon.EuiIcon, {
          className: "euiSelectableListItem__icon",
          color: color,
          type: icon
        });
      }

      var state;
      var instruction;

      if (allowExclusions && checked === 'on') {
        state = (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.includedOption",
          default: "Selected option."
        });
        instruction = (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.includedOptionInstructions",
          default: "To exclude this option, press enter."
        });
      } else if (allowExclusions && checked === 'off') {
        state = (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.excludedOption",
          default: "Excluded option."
        });
        instruction = (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.excludedOptionInstructions",
          default: "To uncheck this option, press enter."
        });
      } else if (allowExclusions && !checked) {
        instruction = (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.unckeckedOptionInstructions",
          default: "To select this option, press enter."
        });
      }

      var isChecked = !disabled && typeof checked === 'string';

      if (!allowExclusions && isChecked) {
        state = (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.checkedOption",
          default: "Checked option."
        });
        instruction = searchable ? (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiSelectableListItem.checkedOptionInstructions",
          default: "To uncheck this option, press enter."
        }) : undefined;
      }

      var prependNode;

      if (prepend) {
        prependNode = (0, _react2.jsx)("span", {
          className: "euiSelectableListItem__prepend"
        }, prepend);
      }

      var appendNode;

      if (append || !!onFocusBadge) {
        var onFocusBadgeNode;
        var defaultOnFocusBadgeProps = {
          'aria-hidden': true,
          iconType: 'returnKey',
          iconSide: 'left',
          color: 'hollow'
        };

        if (onFocusBadge === true) {
          onFocusBadgeNode = (0, _react2.jsx)(_badge.EuiBadge, (0, _extends2.default)({
            className: "euiSelectableListItem__onFocusBadge"
          }, defaultOnFocusBadgeProps));
        } else if (!!onFocusBadge && onFocusBadge !== false) {
          var _children = onFocusBadge.children,
              _className = onFocusBadge.className,
              restBadgeProps = (0, _objectWithoutProperties2.default)(onFocusBadge, ["children", "className"]);
          onFocusBadgeNode = (0, _react2.jsx)(_badge.EuiBadge, (0, _extends2.default)({
            className: (0, _classnames.default)('euiSelectableListItem__onFocusBadge', _className)
          }, defaultOnFocusBadgeProps, restBadgeProps), _children);
        } // Only display the append wrapper if append exists or isFocused


        if (append || isFocused && !disabled) {
          appendNode = (0, _react2.jsx)("span", {
            className: "euiSelectableListItem__append"
          }, append, " ", isFocused && !disabled ? onFocusBadgeNode : null);
        }
      }

      var instructions = (instruction || state) && (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("div", null, state || instruction ? ' - ' : null, state, state && instruction ? ' ' : null, instruction));
      return (0, _react2.jsx)("li", (0, _extends2.default)({
        role: role,
        "data-test-selected": isChecked // Whether the item is checked/selected
        ,
        "aria-checked": role === 'option' ? isChecked : undefined // Whether the item is "checked"
        ,
        "aria-selected": !disabled && isFocused // Whether the item has keyboard focus per W3 spec
        ,
        className: classes,
        "aria-disabled": disabled
      }, rest), (0, _react2.jsx)("span", {
        className: "euiSelectableListItem__content"
      }, optionIcon, prependNode, (0, _react2.jsx)("span", {
        className: textClasses
      }, children, instructions), appendNode));
    }
  }]);
  return EuiSelectableListItem;
}(_react.Component);

exports.EuiSelectableListItem = EuiSelectableListItem;
(0, _defineProperty2.default)(EuiSelectableListItem, "defaultProps", {
  showIcons: true,
  onFocusBadge: true,
  textWrap: 'truncate'
});