"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridCellPopoverActions = exports.EuiDataGridCellActions = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireWildcard(require("react"));

var _i18n = require("../../i18n");

var _button_icon = require("../../button/button_icon");

var _button_empty = require("../../button/button_empty");

var _flex = require("../../flex");

var _popover = require("../../popover");

var _react2 = require("@emotion/react");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiDataGridCellActions = function EuiDataGridCellActions(_ref) {
  var closePopover = _ref.closePopover,
      onExpandClick = _ref.onExpandClick,
      column = _ref.column,
      rowIndex = _ref.rowIndex,
      colIndex = _ref.colIndex;
  // Note: The cell expand button/expansion popover is *always* rendered if
  // column.cellActions is present (regardless of column.isExpandable).
  // This is because cell actions are not otherwise accessible to keyboard
  // or screen reader users
  var expandButton = (0, _react2.jsx)(_i18n.EuiI18n, {
    key: 'expand',
    token: "euiDataGridCellActions.expandButtonTitle",
    default: "Click or hit enter to interact with cell content"
  }, function (expandButtonTitle) {
    return (0, _react2.jsx)(_button_icon.EuiButtonIcon, {
      display: "fill",
      className: "euiDataGridRowCell__actionButtonIcon",
      "data-test-subj": "euiDataGridCellExpandButton",
      color: "primary",
      iconSize: "s",
      iconType: "expandMini",
      "aria-hidden": true,
      onClick: onExpandClick,
      title: expandButtonTitle
    });
  });
  var additionalButtons = (0, _react.useMemo)(function () {
    var ButtonComponent = function ButtonComponent(props) {
      return (0, _react2.jsx)(_button_icon.EuiButtonIcon, (0, _extends2.default)({}, props, {
        "aria-hidden": true,
        className: "euiDataGridRowCell__actionButtonIcon",
        iconSize: "s"
      }));
    };

    return column && Array.isArray(column.cellActions) ? column.cellActions.map(function (Action, idx) {
      // React is more permissible than the TS types indicate
      var ActionButtonElement = Action;
      return (0, _react2.jsx)(ActionButtonElement, {
        key: idx,
        rowIndex: rowIndex,
        colIndex: colIndex,
        columnId: column.id,
        Component: ButtonComponent,
        isExpanded: false,
        closePopover: closePopover
      });
    }) : [];
  }, [column, colIndex, rowIndex, closePopover]);
  return (0, _react2.jsx)("div", {
    className: "euiDataGridRowCell__expandActions"
  }, [].concat((0, _toConsumableArray2.default)(additionalButtons), [expandButton]));
};

exports.EuiDataGridCellActions = EuiDataGridCellActions;

var EuiDataGridCellPopoverActions = function EuiDataGridCellPopoverActions(_ref2) {
  var _column$cellActions;

  var rowIndex = _ref2.rowIndex,
      colIndex = _ref2.colIndex,
      column = _ref2.column;
  if (!(column === null || column === void 0 ? void 0 : (_column$cellActions = column.cellActions) === null || _column$cellActions === void 0 ? void 0 : _column$cellActions.length)) return null;
  return (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, column.cellActions.map(function (Action, idx) {
    var ActionButtonElement = Action;
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      key: idx
    }, (0, _react2.jsx)(ActionButtonElement, {
      rowIndex: rowIndex,
      colIndex: colIndex,
      columnId: column.id,
      Component: function Component(props) {
        return (0, _react2.jsx)(_button_empty.EuiButtonEmpty, (0, _extends2.default)({}, props, {
          size: "s"
        }));
      },
      isExpanded: true
    }));
  })));
};

exports.EuiDataGridCellPopoverActions = EuiDataGridCellPopoverActions;