"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCommonlyUsedTimeRanges = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _i18n = require("../../../i18n");

var _flex = require("../../../flex");

var _title = require("../../../title");

var _link = require("../../../link");

var _services = require("../../../../services");

var _react2 = require("@emotion/react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiCommonlyUsedTimeRanges = function EuiCommonlyUsedTimeRanges(_ref) {
  var applyTime = _ref.applyTime,
      commonlyUsedRanges = _ref.commonlyUsedRanges;
  var legendId = (0, _services.useGeneratedHtmlId)();
  var links = commonlyUsedRanges.map(function (_ref2) {
    var start = _ref2.start,
        end = _ref2.end,
        label = _ref2.label;

    var applyCommonlyUsed = function applyCommonlyUsed() {
      applyTime({
        start: start,
        end: end
      });
    };

    var dataTestSubj = label ? "superDatePickerCommonlyUsed_".concat(label.replace(' ', '_')) : undefined;
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      key: label,
      component: "li",
      className: "euiQuickSelectPopover__sectionItem"
    }, (0, _react2.jsx)(_link.EuiLink, {
      onClick: applyCommonlyUsed,
      "data-test-subj": dataTestSubj
    }, label));
  });
  return (0, _react2.jsx)("fieldset", null, (0, _react2.jsx)(_title.EuiTitle, {
    size: "xxxs"
  }, (0, _react2.jsx)("legend", {
    id: legendId
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiCommonlyUsedTimeRanges.legend",
    default: "Commonly used"
  }))), (0, _react2.jsx)("div", {
    className: "euiQuickSelectPopover__section"
  }, (0, _react2.jsx)(_flex.EuiFlexGrid, {
    "aria-labelledby": legendId,
    gutterSize: "s",
    columns: 2,
    direction: "column",
    responsive: false,
    component: "ul"
  }, links)));
};

exports.EuiCommonlyUsedTimeRanges = EuiCommonlyUsedTimeRanges;
EuiCommonlyUsedTimeRanges.propTypes = {
  applyTime: _propTypes.default.func.isRequired,
  commonlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired
};
EuiCommonlyUsedTimeRanges.displayName = 'EuiCommonlyUsedTimeRanges';