function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useMemo } from 'react';
import { EuiI18n } from '../../i18n';
import { EuiButtonIcon } from '../../button/button_icon';
import { EuiButtonEmpty } from '../../button/button_empty';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiPopoverFooter } from '../../popover';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridCellActions = function EuiDataGridCellActions(_ref) {
  var closePopover = _ref.closePopover,
      onExpandClick = _ref.onExpandClick,
      column = _ref.column,
      rowIndex = _ref.rowIndex,
      colIndex = _ref.colIndex;

  // Note: The cell expand button/expansion popover is *always* rendered if
  // column.cellActions is present (regardless of column.isExpandable).
  // This is because cell actions are not otherwise accessible to keyboard
  // or screen reader users
  var expandButton = ___EmotionJSX(EuiI18n, {
    key: 'expand',
    token: "euiDataGridCellActions.expandButtonTitle",
    default: "Click or hit enter to interact with cell content"
  }, function (expandButtonTitle) {
    return ___EmotionJSX(EuiButtonIcon, {
      display: "fill",
      className: "euiDataGridRowCell__actionButtonIcon",
      "data-test-subj": "euiDataGridCellExpandButton",
      color: "primary",
      iconSize: "s",
      iconType: "expandMini",
      "aria-hidden": true,
      onClick: onExpandClick,
      title: expandButtonTitle
    });
  });

  var additionalButtons = useMemo(function () {
    var ButtonComponent = function ButtonComponent(props) {
      return ___EmotionJSX(EuiButtonIcon, _extends({}, props, {
        "aria-hidden": true,
        className: "euiDataGridRowCell__actionButtonIcon",
        iconSize: "s"
      }));
    };

    return column && Array.isArray(column.cellActions) ? column.cellActions.map(function (Action, idx) {
      // React is more permissible than the TS types indicate
      var ActionButtonElement = Action;
      return ___EmotionJSX(ActionButtonElement, {
        key: idx,
        rowIndex: rowIndex,
        colIndex: colIndex,
        columnId: column.id,
        Component: ButtonComponent,
        isExpanded: false,
        closePopover: closePopover
      });
    }) : [];
  }, [column, colIndex, rowIndex, closePopover]);
  return ___EmotionJSX("div", {
    className: "euiDataGridRowCell__expandActions"
  }, [].concat(_toConsumableArray(additionalButtons), [expandButton]));
};
export var EuiDataGridCellPopoverActions = function EuiDataGridCellPopoverActions(_ref2) {
  var _column$cellActions;

  var rowIndex = _ref2.rowIndex,
      colIndex = _ref2.colIndex,
      column = _ref2.column;
  if (!(column === null || column === void 0 ? void 0 : (_column$cellActions = column.cellActions) === null || _column$cellActions === void 0 ? void 0 : _column$cellActions.length)) return null;
  return ___EmotionJSX(EuiPopoverFooter, null, ___EmotionJSX(EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, column.cellActions.map(function (Action, idx) {
    var ActionButtonElement = Action;
    return ___EmotionJSX(EuiFlexItem, {
      key: idx
    }, ___EmotionJSX(ActionButtonElement, {
      rowIndex: rowIndex,
      colIndex: colIndex,
      columnId: column.id,
      Component: function Component(props) {
        return ___EmotionJSX(EuiButtonEmpty, _extends({}, props, {
          size: "s"
        }));
      },
      isExpanded: true
    }));
  })));
};