"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runOnceSyntheticsMonitorRoute = void 0;

var _configSchema = require("@kbn/config-schema");

var _constants = require("../../../common/constants");

var _monitor_validation = require("./monitor_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const runOnceSyntheticsMonitorRoute = () => ({
  method: 'POST',
  path: _constants.API_URLS.RUN_ONCE_MONITOR + '/{monitorId}',
  validate: {
    body: _configSchema.schema.any(),
    params: _configSchema.schema.object({
      monitorId: _configSchema.schema.string({
        minLength: 1,
        maxLength: 1024
      })
    })
  },
  handler: async ({
    request,
    response,
    server
  }) => {
    const monitor = request.body;
    const {
      monitorId
    } = request.params;
    const validationResult = (0, _monitor_validation.validateMonitor)(monitor);

    if (!validationResult.valid) {
      const {
        reason: message,
        details,
        payload
      } = validationResult;
      return response.badRequest({
        body: {
          message,
          attributes: {
            details,
            ...payload
          }
        }
      });
    }

    const {
      syntheticsService
    } = server;
    const errors = await syntheticsService.runOnceConfigs([{ ...monitor,
      id: monitorId,
      fields_under_root: true,
      fields: {
        run_once: true,
        config_id: monitorId
      }
    }]);

    if (errors) {
      return {
        errors
      };
    }

    return monitor;
  }
});

exports.runOnceSyntheticsMonitorRoute = runOnceSyntheticsMonitorRoute;