"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatSecrets = formatSecrets;
exports.normalizeSecrets = normalizeSecrets;

var _lodash = require("lodash");

var _monitor_management = require("../../../../common/constants/monitor_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


function formatSecrets(monitor) {
  const monitorWithoutSecrets = (0, _lodash.omit)(monitor, _monitor_management.secretKeys);
  const secrets = (0, _lodash.pick)(monitor, _monitor_management.secretKeys);
  return { ...monitorWithoutSecrets,
    secrets: JSON.stringify(secrets)
  };
}

function normalizeSecrets(monitor) {
  return { ...monitor,
    attributes: { ...monitor.attributes,
      ...JSON.parse(monitor.attributes.secrets || '')
    }
  };
}