"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SESSION_ENTRY_LEADERS_ROUTE = exports.QUERY_KEY_PROCESS_EVENTS = exports.QUERY_KEY_ALERTS = exports.PROCESS_EVENTS_ROUTE = exports.PROCESS_EVENTS_PER_PAGE = exports.PROCESS_EVENTS_INDEX = exports.PREVIEW_ALERTS_INDEX = exports.MOUSE_EVENT_PLACEHOLDER = exports.LOCAL_STORAGE_DISPLAY_OPTIONS_KEY = exports.KIBANA_DATE_FORMAT = exports.ENTRY_SESSION_ENTITY_ID_PROPERTY = exports.DEBOUNCE_TIMEOUT = exports.ALERT_UUID_PROPERTY = exports.ALERT_STATUS_ROUTE = exports.ALERT_STATUS = exports.ALERT_COUNT_THRESHOLD = exports.ALERTS_ROUTE = exports.ALERTS_PER_PAGE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROCESS_EVENTS_ROUTE = '/internal/session_view/process_events_route';
exports.PROCESS_EVENTS_ROUTE = PROCESS_EVENTS_ROUTE;
const ALERTS_ROUTE = '/internal/session_view/alerts_route';
exports.ALERTS_ROUTE = ALERTS_ROUTE;
const ALERT_STATUS_ROUTE = '/internal/session_view/alert_status_route';
exports.ALERT_STATUS_ROUTE = ALERT_STATUS_ROUTE;
const SESSION_ENTRY_LEADERS_ROUTE = '/internal/session_view/session_entry_leaders_route';
exports.SESSION_ENTRY_LEADERS_ROUTE = SESSION_ENTRY_LEADERS_ROUTE;
const PROCESS_EVENTS_INDEX = 'logs-endpoint.events.process-*';
exports.PROCESS_EVENTS_INDEX = PROCESS_EVENTS_INDEX;
const PREVIEW_ALERTS_INDEX = '.preview.alerts-security.alerts-default';
exports.PREVIEW_ALERTS_INDEX = PREVIEW_ALERTS_INDEX;
const ENTRY_SESSION_ENTITY_ID_PROPERTY = 'process.entry_leader.entity_id';
exports.ENTRY_SESSION_ENTITY_ID_PROPERTY = ENTRY_SESSION_ENTITY_ID_PROPERTY;
const ALERT_UUID_PROPERTY = 'kibana.alert.uuid';
exports.ALERT_UUID_PROPERTY = ALERT_UUID_PROPERTY;
const KIBANA_DATE_FORMAT = 'MMM DD, YYYY @ HH:mm:ss.SSS';
exports.KIBANA_DATE_FORMAT = KIBANA_DATE_FORMAT;
const ALERT_STATUS = {
  OPEN: 'open',
  ACKNOWLEDGED: 'acknowledged',
  CLOSED: 'closed'
}; // We fetch a large number of events per page to mitigate a few design caveats in session viewer
// 1. Due to the hierarchical nature of the data (e.g we are rendering a time ordered pid tree) there are common scenarios where there
//    are few top level processes, but many nested children. For example, a build script is run on a remote host via ssh. If for example our page
//    size is 10 and the build script has 500 nested children, the user would see a load more button that they could continously click without seeing
//    anychange since the next 10 events would be for processes nested under a top level process that might not be expanded. That being said, it's quite
//    possible there are build scripts with many thousands of events, in which case this initial large page will have the same issue. A technique used
//    in previous incarnations of session view included auto expanding the node which is receiving the new page of events so as to not confuse the user.
//    We may need to include this trick as part of this implementation as well.
// 2. The plain text search that comes with Session view is currently limited in that it only searches through data that has been loaded into the browser.
//    The large page size allows the user to get a broader set of results per page. That being said, this feature is kind of flawed since sessions could be many thousands
//    if not 100s of thousands of events, and to be required to page through these sessions to find more search matches is not a great experience. Future iterations of the
//    search functionality will instead use a separate ES backend search to avoid this.
// 3. Fewer round trips to the backend!

exports.ALERT_STATUS = ALERT_STATUS;
const PROCESS_EVENTS_PER_PAGE = 1000; // As an initial approach, we won't be implementing pagination for alerts.
// Instead we will load this fixed amount of alerts as a maximum for a session.
// This could cause an edge case, where a noisy rule that alerts on every process event
// causes a session to only list and highlight up to 1000 alerts, even though there could
// be far greater than this amount. UX should be added to let the end user know this is
// happening and to revise their rule to be more specific.

exports.PROCESS_EVENTS_PER_PAGE = PROCESS_EVENTS_PER_PAGE;
const ALERTS_PER_PAGE = 501; // when showing the count of alerts in details panel tab, if the number
// exceeds ALERT_COUNT_THRESHOLD we put a + next to it, e.g  500+

exports.ALERTS_PER_PAGE = ALERTS_PER_PAGE;
const ALERT_COUNT_THRESHOLD = 500; // react-query caching keys

exports.ALERT_COUNT_THRESHOLD = ALERT_COUNT_THRESHOLD;
const QUERY_KEY_PROCESS_EVENTS = 'sessionViewProcessEvents';
exports.QUERY_KEY_PROCESS_EVENTS = QUERY_KEY_PROCESS_EVENTS;
const QUERY_KEY_ALERTS = 'sessionViewAlerts';
exports.QUERY_KEY_ALERTS = QUERY_KEY_ALERTS;
const LOCAL_STORAGE_DISPLAY_OPTIONS_KEY = 'sessionView:displayOptions';
exports.LOCAL_STORAGE_DISPLAY_OPTIONS_KEY = LOCAL_STORAGE_DISPLAY_OPTIONS_KEY;
const MOUSE_EVENT_PLACEHOLDER = {
  stopPropagation: () => undefined
};
exports.MOUSE_EVENT_PLACEHOLDER = MOUSE_EVENT_PLACEHOLDER;
const DEBOUNCE_TIMEOUT = 500;
exports.DEBOUNCE_TIMEOUT = DEBOUNCE_TIMEOUT;