"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMockScreenshots = createMockScreenshots;

var _rxjs = require("rxjs");

var _mock = require("../layouts/mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


function createMockScreenshots() {
  return {
    getScreenshots: jest.fn(options => (0, _rxjs.of)({
      layout: (0, _mock.createMockLayout)(),
      results: options.urls.map(() => ({
        timeRange: null,
        screenshots: [{
          data: Buffer.from('screenshot'),
          description: null,
          title: null
        }]
      }))
    }))
  };
}