"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Screenshots = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));

var _rxjs = require("rxjs");

var _operators = require("rxjs/operators");

var _layouts = require("../layouts");

var _observable = require("./observable");

var _semaphore = require("./semaphore");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const DEFAULT_SETUP_RESULT = {
  elementsPositionAndAttributes: null,
  timeRange: null
};

class Screenshots {
  constructor(browserDriverFactory, logger, {
    poolSize
  }) {
    (0, _defineProperty2.default)(this, "semaphore", void 0);
    this.browserDriverFactory = browserDriverFactory;
    this.logger = logger;
    this.semaphore = new _semaphore.Semaphore(poolSize);
  }

  getScreenshots(options) {
    var _options$request$head, _options$request, _options$headers;

    const apmTrans = _elasticApmNode.default.startTransaction('screenshot-pipeline', 'screenshotting');

    const apmCreateLayout = apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.startSpan('create-layout', 'setup');
    const layout = (0, _layouts.createLayout)(options.layout);
    this.logger.debug(`Layout: width=${layout.width} height=${layout.height}`);
    apmCreateLayout === null || apmCreateLayout === void 0 ? void 0 : apmCreateLayout.end();
    const apmCreatePage = apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.startSpan('create-page', 'wait');
    const {
      browserTimezone,
      timeouts: {
        openUrl: openUrlTimeout
      }
    } = options;
    const headers = { ...((_options$request$head = (_options$request = options.request) === null || _options$request === void 0 ? void 0 : _options$request.headers) !== null && _options$request$head !== void 0 ? _options$request$head : {}),
      ...((_options$headers = options.headers) !== null && _options$headers !== void 0 ? _options$headers : {})
    };
    return this.browserDriverFactory.createPage({
      browserTimezone,
      openUrlTimeout,
      defaultViewport: {
        width: layout.width
      }
    }, this.logger).pipe(this.semaphore.acquire(), (0, _operators.mergeMap)(({
      driver,
      unexpectedExit$,
      close
    }) => {
      apmCreatePage === null || apmCreatePage === void 0 ? void 0 : apmCreatePage.end();
      unexpectedExit$.subscribe({
        error: () => apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.end()
      });
      const screen = new _observable.ScreenshotObservableHandler(driver, this.logger, layout, { ...options,
        headers
      });
      return (0, _rxjs.from)(options.urls).pipe((0, _operators.concatMap)((url, index) => screen.setupPage(index, url, apmTrans).pipe((0, _operators.catchError)(error => {
        screen.checkPageIsOpen(); // this fails the job if the browser has closed

        this.logger.error(error);
        return (0, _rxjs.of)({ ...DEFAULT_SETUP_RESULT,
          error
        }); // allow failover screenshot capture
      }), (0, _operators.takeUntil)(unexpectedExit$), screen.getScreenshots())), (0, _operators.take)(options.urls.length), (0, _operators.toArray)(), (0, _operators.mergeMap)(results => // At this point we no longer need the page, close it.
      close().pipe((0, _operators.tap)(({
        metrics
      }) => {
        if (metrics) {
          apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.setLabel('cpu', metrics.cpu, false);
          apmTrans === null || apmTrans === void 0 ? void 0 : apmTrans.setLabel('memory', metrics.memory, false);
        }
      }), (0, _operators.map)(({
        metrics
      }) => ({
        layout,
        metrics,
        results
      })))));
    }), (0, _operators.first)());
  }

}

exports.Screenshots = Screenshots;