"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pngsToPdf = pngsToPdf;

var _pdfmaker = require("./pdfmaker");

var _tracker = require("./tracker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


async function pngsToPdf({
  results,
  layout,
  logo,
  title,
  packageInfo,
  logger
}) {
  const pdfMaker = new _pdfmaker.PdfMaker(layout, logo, packageInfo, logger);
  const tracker = (0, _tracker.getTracker)();

  if (title) {
    pdfMaker.setTitle(title);
  }

  results.forEach(result => {
    result.screenshots.forEach(png => {
      var _png$title, _png$description;

      tracker.startAddImage();
      pdfMaker.addImage(png.data, {
        title: (_png$title = png.title) !== null && _png$title !== void 0 ? _png$title : undefined,
        description: (_png$description = png.description) !== null && _png$description !== void 0 ? _png$description : undefined
      });
      tracker.endAddImage();
    });
  });
  let buffer = null;

  try {
    var _buffer$byteLength, _buffer;

    tracker.startCompile();
    buffer = await pdfMaker.generate();
    tracker.endCompile();
    const byteLength = (_buffer$byteLength = (_buffer = buffer) === null || _buffer === void 0 ? void 0 : _buffer.byteLength) !== null && _buffer$byteLength !== void 0 ? _buffer$byteLength : 0;
    logger.debug(`PDF buffer byte length: ${byteLength}`);
    tracker.setByteLength(byteLength);
  } catch (err) {
    throw err;
  } finally {
    tracker.end();
  }

  return {
    buffer: Buffer.from(buffer.buffer),
    pageCount: pdfMaker.getPageCount()
  };
}