"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generatePdfObservable = generatePdfObservable;

var _operators = require("rxjs/operators");

var _get_full_redirect_app_url = require("../../common/v2/get_full_redirect_app_url");

var _pdf_tracker = require("../../common/pdf_tracker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


function generatePdfObservable(reporting, job, locatorParams, options) {
  const tracker = (0, _pdf_tracker.getTracker)();
  tracker.startScreenshots();
  /**
   * For each locator we get the relative URL to the redirect app
   */

  const urls = locatorParams.map(locator => [(0, _get_full_redirect_app_url.getFullRedirectAppUrl)(reporting.getConfig(), job.spaceId, job.forceNow), locator]);
  const screenshots$ = reporting.getScreenshots({ ...options,
    urls
  }).pipe((0, _operators.tap)(({
    metrics
  }) => {
    if (metrics) {
      tracker.setCpuUsage(metrics.cpu);
      tracker.setMemoryUsage(metrics.memory);
    }
  }), (0, _operators.mergeMap)(async ({
    metrics,
    result
  }) => {
    tracker.endScreenshots();
    const warnings = [];

    if (result.errors) {
      warnings.push(...result.errors.map(error => error.message));
    }

    if (result.renderErrors) {
      warnings.push(...result.renderErrors);
    }

    return {
      buffer: result.data,
      warnings,
      metrics: { ...metrics,
        pages: metrics.pageCount
      }
    };
  }));
  return screenshots$;
}