"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnknownError = exports.ReportingError = exports.QueueTimeoutError = exports.PdfWorkerOutOfMemoryError = exports.KibanaShuttingDownError = exports.BrowserUnexpectedlyClosedError = exports.BrowserScreenshotError = exports.BrowserCouldNotLaunchError = exports.AuthenticationExpiredError = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */


class ReportingError extends Error {
  /**
   * A string that uniquely brands an error type. This is used to power telemetry
   * about reporting failures.
   *
   * @note Convention for codes: lower-case, snake-case and end in `_error`.
   */
  constructor(details) {
    super();
    (0, _defineProperty2.default)(this, "code", void 0);
    this.details = details;
  }

  get message() {
    const prefix = `ReportingError`;
    return this.details ? `${prefix}(code: ${this.code}) "${this.details}"` : `${prefix}(code: ${this.code})`;
  }

  toString() {
    return this.message;
  }

}
/**
 * While performing some reporting action, like fetching data from ES, our
 * access token expired.
 */


exports.ReportingError = ReportingError;

class AuthenticationExpiredError extends ReportingError {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "code", 'authentication_expired_error');
  }

}

exports.AuthenticationExpiredError = AuthenticationExpiredError;

class QueueTimeoutError extends ReportingError {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "code", 'queue_timeout_error');
  }

}
/**
 * An unknown error has occurred. See details.
 */


exports.QueueTimeoutError = QueueTimeoutError;

class UnknownError extends ReportingError {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "code", 'unknown_error');
  }

}

exports.UnknownError = UnknownError;

class PdfWorkerOutOfMemoryError extends ReportingError {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "code", 'pdf_worker_out_of_memory_error');
    (0, _defineProperty2.default)(this, "details", _i18n.i18n.translate('xpack.reporting.common.pdfWorkerOutOfMemoryErrorMessage', {
      defaultMessage: 'Cannot generate PDF due to low memory. Consider making a smaller PDF before retrying this report.'
    }));
  }
  /**
   * No need to provide extra details, we know exactly what happened and can provide
   * a nicely formatted message
   */


  get message() {
    return this.details;
  }

}

exports.PdfWorkerOutOfMemoryError = PdfWorkerOutOfMemoryError;

class BrowserCouldNotLaunchError extends ReportingError {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "code", 'browser_could_not_launch_error');
    (0, _defineProperty2.default)(this, "details", _i18n.i18n.translate('xpack.reporting.common.browserCouldNotLaunchErrorMessage', {
      defaultMessage: 'Cannot generate screenshots because the browser did not launch.'
    }));
  }
  /**
   * For this error message we expect that users will use the diagnostics
   * functionality in reporting to debug further.
   */


  get message() {
    return this.details;
  }

}

exports.BrowserCouldNotLaunchError = BrowserCouldNotLaunchError;

class BrowserUnexpectedlyClosedError extends ReportingError {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "code", 'browser_unexpectedly_closed_error');
  }

}

exports.BrowserUnexpectedlyClosedError = BrowserUnexpectedlyClosedError;

class BrowserScreenshotError extends ReportingError {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "code", 'browser_screenshot_error');
  }

}

exports.BrowserScreenshotError = BrowserScreenshotError;

class KibanaShuttingDownError extends ReportingError {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "code", 'kibana_shutting_down_error');
  }

}

exports.KibanaShuttingDownError = KibanaShuttingDownError;