"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestCycleIds = void 0;

var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const getAgentLogsEsQuery = () => ({
  index: _constants.AGENT_LOGS_INDEX_PATTERN,
  size: 0,
  query: {
    bool: {
      filter: [{
        term: {
          'status.keyword': 'end'
        }
      }]
    }
  },
  aggs: {
    group: {
      terms: {
        field: 'agent.id.keyword'
      },
      aggs: {
        group_docs: {
          top_hits: {
            size: 1,
            sort: [{
              '@timestamp': {
                order: 'desc'
              }
            }]
          }
        }
      }
    }
  },
  fields: ['cycle_id.keyword', 'agent.id.keyword'],
  _source: false
});

const getCycleId = v => {
  var _v$group_docs$hits$hi, _v$group_docs$hits$hi2;

  return (_v$group_docs$hits$hi = v.group_docs.hits.hits) === null || _v$group_docs$hits$hi === void 0 ? void 0 : (_v$group_docs$hits$hi2 = _v$group_docs$hits$hi[0]) === null || _v$group_docs$hits$hi2 === void 0 ? void 0 : _v$group_docs$hits$hi2.fields['cycle_id.keyword'][0];
};

const getLatestCycleIds = async (esClient, logger) => {
  try {
    const agentLogs = await esClient.search(getAgentLogsEsQuery());
    const aggregations = agentLogs.aggregations;

    if (!aggregations) {
      return;
    }

    const buckets = aggregations.group.buckets;

    if (!Array.isArray(buckets)) {
      return;
    }

    return buckets.map(getCycleId);
  } catch (err) {
    logger.error('Failed to fetch cycle_ids');
    throw new Error('Failed to fetch cycle_ids');
  }
};

exports.getLatestCycleIds = getLatestCycleIds;