"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeCspTransformsIndices = exports.createIndexIfNotExists = void 0;

var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");

var _benchmark_score_mapping = require("./benchmark_score_mapping");

var _latest_findings_mapping = require("./latest_findings_mapping");

var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO: Add integration tests


const initializeCspTransformsIndices = async (esClient, logger) => {
  createIndexIfNotExists(esClient, _constants.LATEST_FINDINGS_INDEX_NAME, _constants.LATEST_FINDINGS_INDEX_PATTERN, _latest_findings_mapping.latestFindingsMapping, logger);
  createIndexIfNotExists(esClient, _constants.BENCHMARK_SCORE_INDEX_NAME, _constants.BENCHMARK_SCORE_INDEX_PATTERN, _benchmark_score_mapping.benchmarkScoreMapping, logger);
};

exports.initializeCspTransformsIndices = initializeCspTransformsIndices;

const createIndexIfNotExists = async (esClient, indexName, indexPattern, mappings, logger) => {
  try {
    const isLatestIndexExists = await esClient.indices.exists({
      index: indexPattern
    });

    if (!isLatestIndexExists) {
      await esClient.indices.putIndexTemplate({
        name: indexName,
        index_patterns: indexPattern,
        template: {
          mappings
        },
        priority: 500
      });
      await esClient.indices.create({
        index: indexPattern,
        mappings
      });
    }
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    logger.error(`Failed to create ${_constants.LATEST_FINDINGS_INDEX_PATTERN}`);
    logger.error(error.message);
  }
};

exports.createIndexIfNotExists = createIndexIfNotExists;