"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_RULES_CONFIG_ROUTE_PATH = exports.STATS_ROUTE_PATH = exports.RULE_PASSED = exports.RULE_FAILED = exports.LATEST_FINDINGS_INDEX_PATTERN = exports.LATEST_FINDINGS_INDEX_NAME = exports.INTERNAL_FEATURE_FLAGS = exports.FINDINGS_ROUTE_PATH = exports.CSP_KUBEBEAT_INDEX_PATTERN = exports.CSP_FINDINGS_INDEX_NAME = exports.CIS_KUBERNETES_PACKAGE_NAME = exports.BENCHMARK_SCORE_INDEX_PATTERN = exports.BENCHMARK_SCORE_INDEX_NAME = exports.BENCHMARKS_ROUTE_PATH = exports.AGENT_LOGS_INDEX_PATTERN = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATS_ROUTE_PATH = '/api/csp/stats';
exports.STATS_ROUTE_PATH = STATS_ROUTE_PATH;
const FINDINGS_ROUTE_PATH = '/api/csp/findings';
exports.FINDINGS_ROUTE_PATH = FINDINGS_ROUTE_PATH;
const BENCHMARKS_ROUTE_PATH = '/api/csp/benchmarks';
exports.BENCHMARKS_ROUTE_PATH = BENCHMARKS_ROUTE_PATH;
const UPDATE_RULES_CONFIG_ROUTE_PATH = '/api/csp/update_rules_config';
exports.UPDATE_RULES_CONFIG_ROUTE_PATH = UPDATE_RULES_CONFIG_ROUTE_PATH;
const CSP_FINDINGS_INDEX_NAME = 'findings';
exports.CSP_FINDINGS_INDEX_NAME = CSP_FINDINGS_INDEX_NAME;
const CIS_KUBERNETES_PACKAGE_NAME = 'cis_kubernetes_benchmark';
exports.CIS_KUBERNETES_PACKAGE_NAME = CIS_KUBERNETES_PACKAGE_NAME;
const LATEST_FINDINGS_INDEX_NAME = 'cloud_security_posture.findings_latest';
exports.LATEST_FINDINGS_INDEX_NAME = LATEST_FINDINGS_INDEX_NAME;
const BENCHMARK_SCORE_INDEX_NAME = 'cloud_security_posture.scores';
exports.BENCHMARK_SCORE_INDEX_NAME = BENCHMARK_SCORE_INDEX_NAME;
const AGENT_LOGS_INDEX_PATTERN = '.logs-cis_kubernetes_benchmark.metadata*';
exports.AGENT_LOGS_INDEX_PATTERN = AGENT_LOGS_INDEX_PATTERN;
const CSP_KUBEBEAT_INDEX_PATTERN = 'logs-cis_kubernetes_benchmark.findings*';
exports.CSP_KUBEBEAT_INDEX_PATTERN = CSP_KUBEBEAT_INDEX_PATTERN;
const LATEST_FINDINGS_INDEX_PATTERN = 'logs-' + LATEST_FINDINGS_INDEX_NAME + '-default';
exports.LATEST_FINDINGS_INDEX_PATTERN = LATEST_FINDINGS_INDEX_PATTERN;
const BENCHMARK_SCORE_INDEX_PATTERN = 'logs-' + BENCHMARK_SCORE_INDEX_NAME + '-default';
exports.BENCHMARK_SCORE_INDEX_PATTERN = BENCHMARK_SCORE_INDEX_PATTERN;
const RULE_PASSED = `passed`;
exports.RULE_PASSED = RULE_PASSED;
const RULE_FAILED = `failed`; // A mapping of in-development features to their status. These features should be hidden from users but can be easily
// activated via a simple code change in a single location.

exports.RULE_FAILED = RULE_FAILED;
const INTERNAL_FEATURE_FLAGS = {
  showBenchmarks: false,
  showTrendLineMock: false,
  showManageRulesMock: false,
  showRisksMock: false
};
exports.INTERNAL_FEATURE_FLAGS = INTERNAL_FEATURE_FLAGS;