"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBrowserConfig = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const createBrowserConfig = (config, descriptor) => {
  return recursiveCreateConfig(config, descriptor);
};

exports.createBrowserConfig = createBrowserConfig;

const recursiveCreateConfig = (config, descriptor = {}) => {
  return Object.entries(config || {}).reduce((browserConfig, [key, value]) => {
    const exposedConfig = descriptor[key];

    if (exposedConfig && typeof exposedConfig === 'object') {
      browserConfig[key] = recursiveCreateConfig(value, exposedConfig);
    }

    if (exposedConfig === true) {
      browserConfig[key] = value;
    }

    return browserConfig;
  }, {});
};