"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TsLib = exports.StyledComponents = exports.SaferLodashSet = exports.RxjsOperators = exports.Rxjs = exports.RisonNode = exports.ReactRouterDom = exports.ReactRouter = exports.ReactDomServer = exports.ReactDom = exports.ReactBeautifulDnD = exports.React = exports.MonacoBarePluginApi = exports.MomentTimezone = exports.Moment = exports.LodashFp = exports.Lodash = exports.KbnUiTheme = exports.KbnStd = exports.KbnMonaco = exports.KbnI18nReact = exports.KbnI18n = exports.KbnDatemath = exports.KbnAnalytics = exports.Jquery = exports.History = exports.Fflate = exports.EmotionReact = exports.ElasticNumeral = exports.ElasticEuiLibServicesFormat = exports.ElasticEuiLibServices = exports.ElasticEuiChartsTheme = exports.ElasticEui = exports.ElasticCharts = exports.Classnames = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
require('./polyfills');

const Jquery = require('jquery');

exports.Jquery = Jquery;
window.$ = window.jQuery = Jquery; // mutates window.jQuery and window.$

require('@kbn/flot-charts'); // stateful deps


const KbnUiTheme = require('@kbn/ui-theme');

exports.KbnUiTheme = KbnUiTheme;

const KbnI18n = require('@kbn/i18n');

exports.KbnI18n = KbnI18n;

const KbnI18nReact = require('@kbn/i18n-react');

exports.KbnI18nReact = KbnI18nReact;

const EmotionReact = require('@emotion/react');

exports.EmotionReact = EmotionReact;

const Moment = require('moment');

exports.Moment = Moment;

const MomentTimezone = require('moment-timezone/moment-timezone');

exports.MomentTimezone = MomentTimezone;

const KbnMonaco = require('@kbn/monaco');

exports.KbnMonaco = KbnMonaco;

const MonacoBarePluginApi = require('@kbn/monaco').BarePluginApi;

exports.MonacoBarePluginApi = MonacoBarePluginApi;

const React = require('react');

exports.React = React;

const ReactDom = require('react-dom');

exports.ReactDom = ReactDom;

const ReactDomServer = require('react-dom/server'); // eslint-disable-next-line @kbn/eslint/module_migration


exports.ReactDomServer = ReactDomServer;

const ReactRouter = require('react-router');

exports.ReactRouter = ReactRouter;

const ReactRouterDom = require('react-router-dom');

exports.ReactRouterDom = ReactRouterDom;

const StyledComponents = require('styled-components');

exports.StyledComponents = StyledComponents;
Moment.tz.load(require('moment-timezone/data/packed/latest.json')); // big deps which are locked to a single version

const Rxjs = require('rxjs');

exports.Rxjs = Rxjs;

const RxjsOperators = require('rxjs/operators');

exports.RxjsOperators = RxjsOperators;

const ElasticNumeral = require('@elastic/numeral');

exports.ElasticNumeral = ElasticNumeral;

const ElasticCharts = require('@elastic/charts');

exports.ElasticCharts = ElasticCharts;

const ElasticEui = require('@elastic/eui');

exports.ElasticEui = ElasticEui;

const ElasticEuiLibServices = require('@elastic/eui/lib/services');

exports.ElasticEuiLibServices = ElasticEuiLibServices;

const ElasticEuiLibServicesFormat = require('@elastic/eui/lib/services/format');

exports.ElasticEuiLibServicesFormat = ElasticEuiLibServicesFormat;

const ElasticEuiChartsTheme = require('@elastic/eui/dist/eui_charts_theme');

exports.ElasticEuiChartsTheme = ElasticEuiChartsTheme;

const KbnDatemath = require('@kbn/datemath');

exports.KbnDatemath = KbnDatemath;

const ReactBeautifulDnD = require('react-beautiful-dnd');

exports.ReactBeautifulDnD = ReactBeautifulDnD;

const Lodash = require('lodash');

exports.Lodash = Lodash;

const LodashFp = require('lodash/fp');

exports.LodashFp = LodashFp;

const {
  unzlibSync,
  strFromU8
} = require('fflate');

const Fflate = {
  unzlibSync,
  strFromU8
}; // runtime deps which don't need to be copied across all bundles

exports.Fflate = Fflate;

const TsLib = require('tslib');

exports.TsLib = TsLib;

const KbnAnalytics = require('@kbn/analytics');

exports.KbnAnalytics = KbnAnalytics;

const KbnStd = require('@kbn/std');

exports.KbnStd = KbnStd;

const SaferLodashSet = require('@elastic/safer-lodash-set');

exports.SaferLodashSet = SaferLodashSet;

const RisonNode = require('rison-node');

exports.RisonNode = RisonNode;

const History = require('history');

exports.History = History;

const Classnames = require('classnames');

exports.Classnames = Classnames;