/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { version } from '@kbn/securitysolution-io-ts-types';
import { _versionOrUndefined } from '../../common/underscore_version';
import { deserializerOrUndefined } from '../../common/deserializer';
import { metaOrUndefined } from '../../common/meta';
import { serializerOrUndefined } from '../../common/serializer';
import { created_at } from '../../common/created_at';
import { created_by } from '../../common/created_by';
import { description } from '../../common/description';
import { id } from '../../common/id';
import { immutable } from '../../common/immutable';
import { name } from '../../common/name';
import { tie_breaker_id } from '../../common/tie_breaker_id';
import { type } from '../../common/type';
import { updated_at } from '../../common/updated_at';
import { updated_by } from '../../common/updated_by';
export var listSchema = t.exact(t.type({
  _version: _versionOrUndefined,
  created_at: created_at,
  created_by: created_by,
  description: description,
  deserializer: deserializerOrUndefined,
  id: id,
  immutable: immutable,
  meta: metaOrUndefined,
  name: name,
  serializer: serializerOrUndefined,
  tie_breaker_id: tie_breaker_id,
  type: type,
  updated_at: updated_at,
  updated_by: updated_by,
  version: version
}));
export var listArraySchema = t.array(listSchema);