/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { DefaultArray } from '@kbn/securitysolution-io-ts-types';
export var osType = t.keyof({
  linux: null,
  macos: null,
  windows: null
});
export var osTypeArray = DefaultArray(osType);
export var osTypeArrayOrUndefined = t.union([osTypeArray, t.undefined]);