/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable @typescript-eslint/naming-convention */
import * as t from 'io-ts';
/**
 * TODO: This type are originally from "src/core/types/saved_objects.ts", once that is package friendly remove
 * this copied type.
 *
 * Don't use this type, it's simply a helper type for {@link SavedObjectAttribute}
 *
 * @public
 */

export var saved_object_attribute_single = t.recursion('saved_object_attribute_single', function () {
  return t.union([t.string, t.number, t["boolean"], t["null"], t.undefined, saved_object_attributes]);
});
export var saved_object_attribute = t.recursion('saved_object_attribute', function () {
  return t.union([saved_object_attribute_single, t.array(saved_object_attribute_single)]);
});
export var saved_object_attributes = t.recursion('saved_object_attributes', function () {
  return t.record(t.string, saved_object_attribute);
});