"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simpleKibanaPlatformPluginDiscovery = simpleKibanaPlatformPluginDiscovery;

var _path = _interopRequireDefault(require("path"));

var _globby = _interopRequireDefault(require("globby"));

var _normalizePath = _interopRequireDefault(require("normalize-path"));

var _parse_kibana_platform_plugin = require("./parse_kibana_platform_plugin");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper to find the new platform plugins.
 */
function simpleKibanaPlatformPluginDiscovery(scanDirs, pluginPaths) {
  const patterns = Array.from(new Set([// find kibana.json files up to 5 levels within the scan dir
  ...scanDirs.reduce((acc, dir) => [...acc, _path.default.resolve(dir, '*/kibana.json'), _path.default.resolve(dir, '*/*/kibana.json'), _path.default.resolve(dir, '*/*/*/kibana.json'), _path.default.resolve(dir, '*/*/*/*/kibana.json'), _path.default.resolve(dir, '*/*/*/*/*/kibana.json')], []), ...pluginPaths.map(path => _path.default.resolve(path, `kibana.json`))])).map(path => (0, _normalizePath.default)(path));

  const manifestPaths = _globby.default.sync(patterns, {
    absolute: true
  }).map(path => // absolute paths returned from globby are using normalize or
  // something so the path separators are `/` even on windows,
  // Path.resolve solves this
  _path.default.resolve(path));

  return manifestPaths.map(_parse_kibana_platform_plugin.parseKibanaPlatformPlugin);
}