import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _typeof from "@babel/runtime/helpers/typeof";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
export var isString = function isString(value) {
  return typeof value === 'string';
};
export var isObject = function isObject(value) {
  return _typeof(value) === 'object' && value !== null;
};
export var hasValues = function hasValues(values) {
  return Object.keys(values).length > 0;
};
export var unique = function unique() {
  var arr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return _toConsumableArray(new Set(arr));
};

var merge = function merge(a, b) {
  return unique([].concat(_toConsumableArray(Object.keys(a)), _toConsumableArray(Object.keys(b)))).reduce(function (acc, key) {
    if (isObject(a[key]) && isObject(b[key]) && !Array.isArray(a[key]) && !Array.isArray(b[key])) {
      return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, key, merge(a[key], b[key])));
    }

    return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, key, b[key] === undefined ? a[key] : b[key]));
  }, {});
};

export var mergeAll = function mergeAll() {
  for (var _len = arguments.length, sources = new Array(_len), _key = 0; _key < _len; _key++) {
    sources[_key] = arguments[_key];
  }

  return sources.filter(isObject).reduce(function (acc, source) {
    return merge(acc, source);
  });
};