/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as literal from '../../node_types/literal';
import * as wildcard from '../../node_types/wildcard';
export function getFields(node, indexPattern) {
  if (!indexPattern) return [];

  if (node.type === 'literal') {
    var fieldName = literal.toElasticsearchQuery(node);
    var field = indexPattern.fields.find(function (fld) {
      return fld.name === fieldName;
    });

    if (!field) {
      return [];
    }

    return [field];
  } else if (node.type === 'wildcard') {
    var fields = indexPattern.fields.filter(function (fld) {
      return wildcard.test(node, fld.name);
    });
    return fields;
  }
}