import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { has } from 'lodash';

/**
 * @param filter
 * @returns `true` if a filter is a `QueryStringFilter`
 *
 * @public
 */
export var isQueryStringFilter = function isQueryStringFilter(filter) {
  return has(filter, 'query.query_string');
};
/**
 * Creates a filter corresponding to a raw Elasticsearch query DSL object
 * @param query
 * @param index
 * @param alias
 * @returns `QueryStringFilter`
 *
 * @public
 */

export var buildQueryFilter = function buildQueryFilter(query, index, alias) {
  var meta = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  return {
    query: query,
    meta: _objectSpread({
      index: index,
      alias: alias
    }, meta)
  };
};