"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonPopoverContent = exports.DefaultCellPopover = exports.useCellPopover = exports.DataGridCellPopoverContext = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _services = require("../../../services");

var _popover = require("../../popover");

var _text = require("../../text");

var _code = require("../../code");

var _react2 = require("@emotion/react");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var DataGridCellPopoverContext = /*#__PURE__*/(0, _react.createContext)({
  popoverIsOpen: false,
  cellLocation: {
    rowIndex: 0,
    colIndex: 0
  },
  openCellPopover: function openCellPopover() {},
  closeCellPopover: function closeCellPopover() {},
  setPopoverAnchor: function setPopoverAnchor() {},
  setPopoverContent: function setPopoverContent() {}
});
exports.DataGridCellPopoverContext = DataGridCellPopoverContext;

var useCellPopover = function useCellPopover() {
  // Current open state & cell location are handled here
  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      popoverIsOpen = _useState2[0],
      setPopoverIsOpen = _useState2[1];

  var _useState3 = (0, _react.useState)({
    rowIndex: 0,
    colIndex: 0
  }),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      cellLocation = _useState4[0],
      setCellLocation = _useState4[1]; // Popover anchor & content are passed by individual `EuiDataGridCell`s


  var _useState5 = (0, _react.useState)(null),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      popoverAnchor = _useState6[0],
      setPopoverAnchor = _useState6[1];

  var _useState7 = (0, _react.useState)(),
      _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
      popoverContent = _useState8[0],
      setPopoverContent = _useState8[1];

  var closeCellPopover = (0, _react.useCallback)(function () {
    return setPopoverIsOpen(false);
  }, []);
  var openCellPopover = (0, _react.useCallback)(function (_ref) {
    var rowIndex = _ref.rowIndex,
        colIndex = _ref.colIndex;

    // Prevent popover DOM issues when re-opening the same popover
    if (popoverIsOpen && rowIndex === cellLocation.rowIndex && colIndex === cellLocation.colIndex) {
      return;
    } // Toggle our open cell state, which causes EuiDataGridCells to react/check
    // if they should be the open popover and send their anchor+content if so


    setPopoverAnchor(null); // Resetting the anchor node is required for rerendering to work correctly

    setCellLocation({
      rowIndex: rowIndex,
      colIndex: colIndex
    });
    setPopoverIsOpen(true);
  }, [popoverIsOpen, cellLocation]);
  var cellPopoverContext = {
    popoverIsOpen: popoverIsOpen,
    closeCellPopover: closeCellPopover,
    openCellPopover: openCellPopover,
    cellLocation: cellLocation,
    setPopoverAnchor: setPopoverAnchor,
    setPopoverContent: setPopoverContent
  }; // Note that this popover is rendered once at the top grid level, rather than one popover per cell

  var cellPopover = popoverIsOpen && popoverAnchor && (0, _react2.jsx)(_popover.EuiWrappingPopover, {
    isOpen: popoverIsOpen,
    button: popoverAnchor,
    display: "block",
    hasArrow: false,
    panelPaddingSize: "s",
    panelClassName: "euiDataGridRowCell__popover",
    panelProps: {
      'data-test-subj': 'euiDataGridExpansionPopover'
    },
    closePopover: closeCellPopover,
    onKeyDown: function onKeyDown(event) {
      if (event.key === _services.keys.F2 || event.key === _services.keys.ESCAPE) {
        event.preventDefault();
        event.stopPropagation();
        closeCellPopover();
      }
    }
  }, popoverContent);
  return {
    cellPopoverContext: cellPopoverContext,
    cellPopover: cellPopover
  };
};
/**
 * Popover content renderers
 */


exports.useCellPopover = useCellPopover;

var DefaultCellPopover = function DefaultCellPopover(_ref2) {
  var schema = _ref2.schema,
      cellActions = _ref2.cellActions,
      children = _ref2.children,
      cellContentsElement = _ref2.cellContentsElement;

  switch (schema) {
    case 'json':
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(JsonPopoverContent, {
        cellText: cellContentsElement.innerText
      }), cellActions);

    default:
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_text.EuiText, null, children), cellActions);
  }
};

exports.DefaultCellPopover = DefaultCellPopover;

var JsonPopoverContent = function JsonPopoverContent(_ref3) {
  var cellText = _ref3.cellText;
  var formattedText = cellText;

  try {
    formattedText = JSON.stringify(JSON.parse(formattedText), null, 2);
  } catch (e) {} // eslint-disable-line no-empty


  return (0, _react2.jsx)(_code.EuiCodeBlock, {
    isCopyable: true,
    transparentBackground: true,
    paddingSize: "none",
    language: "json"
  }, formattedText);
};

exports.JsonPopoverContent = JsonPopoverContent;