"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.I18nContext = exports.EuiI18nConsumer = exports.EuiContext = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react2 = require("@emotion/react");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var I18nContext = /*#__PURE__*/(0, _react.createContext)({});
exports.I18nContext = I18nContext;
var EuiI18nProvider = I18nContext.Provider,
    EuiI18nConsumer = I18nContext.Consumer;
exports.EuiI18nConsumer = EuiI18nConsumer;

var EuiContext = function EuiContext(_ref) {
  var _ref$i18n = _ref.i18n,
      i18n = _ref$i18n === void 0 ? {} : _ref$i18n,
      children = _ref.children;
  return (0, _react2.jsx)(EuiI18nProvider, {
    value: i18n
  }, children);
};

exports.EuiContext = EuiContext;
EuiContext.propTypes = {
  i18n: _propTypes.default.shape({
    mapping: _propTypes.default.shape({}),
    mappingFunc: _propTypes.default.func,

    /**
       * Some browsers' translation features don't work with a rendered `<Fragment>` component.
       * The `render` function allows you to pass in another component instead, e.g. `<div>`
       */
    render: _propTypes.default.func,
    formatNumber: _propTypes.default.func,
    formatDateTime: _propTypes.default.func,
    locale: _propTypes.default.string
  }).isRequired,

  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node.isRequired
};