"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMarkStyles = void 0;

var _react = require("@emotion/react");

var _services = require("../../services");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiMarkStyles = function euiMarkStyles(_ref) {
  var euiTheme = _ref.euiTheme,
      colorMode = _ref.colorMode;
  // TODO: Was $euiFocusBackgroundColor
  var transparency = {
    LIGHT: 0.1,
    DARK: 0.3
  };
  return /*#__PURE__*/(0, _react.css)("background-color:", (0, _services.transparentize)(euiTheme.colors.primary, transparency[colorMode]), ";font-weight:", euiTheme.font.weight.bold, ";color:", euiTheme.colors.text, ";;label:euiMarkStyles;" + (process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL21hcmsvbWFyay5zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBZVkiLCJmaWxlIjoiLi4vLi4vLi4vLi4vc3JjL2NvbXBvbmVudHMvbWFyay9tYXJrLnN0eWxlcy50cyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgRWxhc3RpY3NlYXJjaCBCLlYuIGFuZC9vciBsaWNlbnNlZCB0byBFbGFzdGljc2VhcmNoIEIuVi4gdW5kZXIgb25lXG4gKiBvciBtb3JlIGNvbnRyaWJ1dG9yIGxpY2Vuc2UgYWdyZWVtZW50cy4gTGljZW5zZWQgdW5kZXIgdGhlIEVsYXN0aWMgTGljZW5zZVxuICogMi4wIGFuZCB0aGUgU2VydmVyIFNpZGUgUHVibGljIExpY2Vuc2UsIHYgMTsgeW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHRcbiAqIGluIGNvbXBsaWFuY2Ugd2l0aCwgYXQgeW91ciBlbGVjdGlvbiwgdGhlIEVsYXN0aWMgTGljZW5zZSAyLjAgb3IgdGhlIFNlcnZlclxuICogU2lkZSBQdWJsaWMgTGljZW5zZSwgdiAxLlxuICovXG5cbmltcG9ydCB7IGNzcyB9IGZyb20gJ0BlbW90aW9uL3JlYWN0JztcbmltcG9ydCB7IFVzZUV1aVRoZW1lLCB0cmFuc3BhcmVudGl6ZSB9IGZyb20gJy4uLy4uL3NlcnZpY2VzJztcblxuZXhwb3J0IGNvbnN0IGV1aU1hcmtTdHlsZXMgPSAoeyBldWlUaGVtZSwgY29sb3JNb2RlIH06IFVzZUV1aVRoZW1lKSA9PiB7XG4gIC8vIFRPRE86IFdhcyAkZXVpRm9jdXNCYWNrZ3JvdW5kQ29sb3JcbiAgY29uc3QgdHJhbnNwYXJlbmN5ID0geyBMSUdIVDogMC4xLCBEQVJLOiAwLjMgfTtcblxuICByZXR1cm4gY3NzYFxuICAgIGJhY2tncm91bmQtY29sb3I6ICR7dHJhbnNwYXJlbnRpemUoXG4gICAgICBldWlUaGVtZS5jb2xvcnMucHJpbWFyeSxcbiAgICAgIHRyYW5zcGFyZW5jeVtjb2xvck1vZGVdXG4gICAgKX07XG4gICAgZm9udC13ZWlnaHQ6ICR7ZXVpVGhlbWUuZm9udC53ZWlnaHQuYm9sZH07XG4gICAgLy8gT3ZlcnJpZGUgdGhlIGJyb3dzZXIncyBibGFjayBjb2xvci5cbiAgICAvLyBDYW4ndCB1c2UgJ2luaGVyaXQnIGJlY2F1c2UgdGhlIHRleHQgdG8gYmFja2dyb3VuZCBjb2xvciBjb250cmFzdCBtYXkgbm90IGJlIHN1ZmZpY2llbnRcbiAgICBjb2xvcjogJHtldWlUaGVtZS5jb2xvcnMudGV4dH07XG4gIGA7XG59O1xuIl19 */"));
};

exports.euiMarkStyles = euiMarkStyles;