"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridCell = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireWildcard(require("react"));

var _reactDom = require("react-dom");

var _tabbable = _interopRequireDefault(require("tabbable"));

var _services = require("../../../services");

var _accessibility = require("../../accessibility");

var _focus_trap = require("../../focus_trap");

var _i18n = require("../../i18n");

var _resize_observer = require("../../observer/resize_observer/resize_observer");

var _focus = require("../utils/focus");

var _data_grid_cell_actions = require("./data_grid_cell_actions");

var _data_grid_cell_popover = require("./data_grid_cell_popover");

var _utils = require("../../../utils");

var _react2 = require("@emotion/react");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

var EuiDataGridCellContent = /*#__PURE__*/(0, _react.memo)(function (_ref) {
  var renderCellValue = _ref.renderCellValue,
      column = _ref.column,
      setCellContentsRef = _ref.setCellContentsRef,
      rowHeightsOptions = _ref.rowHeightsOptions,
      rowIndex = _ref.rowIndex,
      colIndex = _ref.colIndex,
      rowHeightUtils = _ref.rowHeightUtils,
      isDefinedHeight = _ref.isDefinedHeight,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["renderCellValue", "column", "setCellContentsRef", "rowHeightsOptions", "rowIndex", "colIndex", "rowHeightUtils", "isDefinedHeight"]);
  // React is more permissible than the TS types indicate
  var CellElement = renderCellValue;
  var positionText = (0, _i18n.useEuiI18n)('euiDataGridCell.position', 'Row: {row}; Column: {col}', {
    row: rowIndex + 1,
    col: colIndex + 1
  });
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("div", {
    ref: setCellContentsRef,
    "data-datagrid-cellcontent": true,
    className: isDefinedHeight ? 'euiDataGridRowCell__definedHeight' : 'euiDataGridRowCell__truncate',
    style: isDefinedHeight ? rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getStylesForCell(rowHeightsOptions, rowIndex) : {}
  }, (0, _react2.jsx)(CellElement, (0, _extends2.default)({
    isDetails: false,
    "data-test-subj": "cell-content",
    rowIndex: rowIndex,
    colIndex: colIndex,
    schema: (column === null || column === void 0 ? void 0 : column.schema) || rest.columnType
  }, rest))), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, positionText)));
});

var EuiDataGridCell = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiDataGridCell, _Component);

  var _super = _createSuper(EuiDataGridCell);

  function EuiDataGridCell() {
    var _this;

    (0, _classCallCheck2.default)(this, EuiDataGridCell);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "cellRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "contentObserver", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "popoverAnchorRef", /*#__PURE__*/(0, _react.createRef)());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "cellContentsRef", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      cellProps: {},
      isFocused: false,
      isEntered: false,
      enableInteractions: false,
      disableCellTabIndex: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "unsubscribeCell", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "focusTimeout", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "style", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getInteractables", function () {
      var tabbingRef = _this.cellContentsRef;

      if (tabbingRef) {
        return tabbingRef.querySelectorAll('[data-datagrid-interactable=true]');
      }

      return [];
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "takeFocus", function (preventScroll) {
      var cell = _this.cellRef.current;

      if (cell) {
        // only update focus if we are not already focused on something in this cell
        var element = document.activeElement;

        while (element != null && element !== cell) {
          element = element.parentElement;
        }

        var doFocusUpdate = element !== cell;

        if (doFocusUpdate) {
          var interactables = _this.getInteractables();

          if (_this.isExpandable() === false && interactables.length === 1) {
            // Only one element can be interacted with
            interactables[0].focus({
              preventScroll: preventScroll
            });
          } else {
            cell.focus({
              preventScroll: preventScroll
            });
          }
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "recalculateAutoHeight", function () {
      var _this$props = _this.props,
          rowHeightUtils = _this$props.rowHeightUtils,
          rowHeightsOptions = _this$props.rowHeightsOptions,
          rowIndex = _this$props.rowIndex;

      if (_this.cellContentsRef && rowHeightUtils && rowHeightUtils.isAutoHeight(rowIndex, rowHeightsOptions)) {
        var _this$props2 = _this.props,
            columnId = _this$props2.columnId,
            visibleRowIndex = _this$props2.visibleRowIndex;
        var rowHeight = _this.cellContentsRef.offsetHeight;
        rowHeightUtils.setRowHeight(rowIndex, columnId, rowHeight, visibleRowIndex);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "recalculateLineHeight", function () {
      if (!_this.props.setRowHeight) return; // setRowHeight is only passed by data_grid_body into one cell per row

      if (!_this.cellContentsRef) return;
      var _this$props3 = _this.props,
          rowHeightUtils = _this$props3.rowHeightUtils,
          rowHeightsOptions = _this$props3.rowHeightsOptions,
          rowIndex = _this$props3.rowIndex;
      var rowHeightOption = rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getRowHeightOption(rowIndex, rowHeightsOptions);
      var isSingleLine = rowHeightOption == null; // Undefined rowHeightsOptions default to a single line

      var lineCount = isSingleLine ? 1 : rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getLineCount(rowHeightOption);

      if (lineCount) {
        var shouldUseHeightsCache = rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.isRowHeightOverride(rowIndex, rowHeightsOptions);
        var height = rowHeightUtils.calculateHeightForLineCount(_this.cellContentsRef, lineCount, shouldUseHeightsCache);

        if (shouldUseHeightsCache) {
          var _this$props4 = _this.props,
              columnId = _this$props4.columnId,
              visibleRowIndex = _this$props4.visibleRowIndex;
          rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.setRowHeight(rowIndex, columnId, height, visibleRowIndex);
        } else {
          _this.props.setRowHeight(height);
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isFocusedCell", function () {
      var _this$context$focused, _this$context$focused2;

      return ((_this$context$focused = _this.context.focusedCell) === null || _this$context$focused === void 0 ? void 0 : _this$context$focused[0]) === _this.props.colIndex && ((_this$context$focused2 = _this.context.focusedCell) === null || _this$context$focused2 === void 0 ? void 0 : _this$context$focused2[1]) === _this.props.visibleRowIndex;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocusUpdate", function (isFocused) {
      var preventScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      _this.setState({
        isFocused: isFocused
      }, function () {
        if (isFocused) {
          _this.takeFocus(preventScroll);
        }
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setCellProps", function (cellProps) {
      _this.setState({
        cellProps: cellProps
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setCellContentsRef", function (ref) {
      _this.cellContentsRef = ref;

      if (ref && _resize_observer.hasResizeObserver) {
        _this.contentObserver = new window.ResizeObserver(function () {
          _this.recalculateAutoHeight();

          _this.recalculateLineHeight();
        });

        _this.contentObserver.observe(ref);
      } else if (_this.contentObserver) {
        _this.contentObserver.disconnect();
      }

      _this.preventTabbing();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocus", function (e) {
      // only perform this logic when the event's originating element (e.target) is
      // the wrapping element with the onFocus logic
      // reasons:
      //  * the outcome is only meaningful when the focus shifts to the wrapping element
      //  * if the cell children include portalled content React will bubble the focus
      //      event up, which can trigger the focus() call below, causing focus lock fighting
      if (_this.cellRef.current === e.target) {
        var _this$props5 = _this.props,
            colIndex = _this$props5.colIndex,
            visibleRowIndex = _this$props5.visibleRowIndex; // focus in next tick to give potential focus capturing mechanisms time to release their traps
        // also clear any previous focus timeout that may still be queued

        if (EuiDataGridCell.activeFocusTimeoutId) {
          window.clearTimeout(EuiDataGridCell.activeFocusTimeoutId);
        }

        EuiDataGridCell.activeFocusTimeoutId = _this.focusTimeout = window.setTimeout(function () {
          _this.context.setFocusedCell([colIndex, visibleRowIndex]);

          var interactables = _this.getInteractables();

          if (interactables.length === 1 && _this.isExpandable() === false) {
            interactables[0].focus();

            _this.setState({
              disableCellTabIndex: true
            });
          }
        }, 0); // Close the cell popover if the popover was open and the user clicked the cell

        if (_this.props.popoverContext.popoverIsOpen) {
          _this.props.popoverContext.closeCellPopover();
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlur", function () {
      _this.setState({
        disableCellTabIndex: false
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "preventTabbing", function () {
      if (_this.cellContentsRef) {
        var tabbables = (0, _tabbable.default)(_this.cellContentsRef);

        for (var i = 0; i < tabbables.length; i++) {
          var element = tabbables[i];
          element.setAttribute('tabIndex', '-1');
          element.setAttribute('data-datagrid-interactable', 'true');
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "enableTabbing", function () {
      if (_this.cellContentsRef) {
        var interactables = _this.getInteractables();

        for (var i = 0; i < interactables.length; i++) {
          var element = interactables[i];
          element.removeAttribute('tabIndex');
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isExpandable", function () {
      var _this$props$column, _this$props$column$ce, _this$state$cellProps;

      // A cell must always show an expansion popover if it has cell actions,
      // otherwise keyboard and screen reader users have no way of accessing them
      if ((_this$props$column = _this.props.column) === null || _this$props$column === void 0 ? void 0 : (_this$props$column$ce = _this$props$column.cellActions) === null || _this$props$column$ce === void 0 ? void 0 : _this$props$column$ce.length) return true; // props.isExpandable inherits from column.isExpandable
      // state.cellProps allows consuming applications to override isExpandable on a per-cell basis

      return (_this$state$cellProps = _this.state.cellProps.isExpandable) !== null && _this$state$cellProps !== void 0 ? _this$state$cellProps : _this.props.isExpandable;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isPopoverOpen", function () {
      var _this$props$popoverCo = _this.props.popoverContext,
          popoverIsOpen = _this$props$popoverCo.popoverIsOpen,
          cellLocation = _this$props$popoverCo.cellLocation;
      return _this.isExpandable() && popoverIsOpen && cellLocation.colIndex === _this.props.colIndex && cellLocation.rowIndex === _this.props.visibleRowIndex;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleCellPopover", function () {
      if (_this.isPopoverOpen()) {
        var _this$props$popoverCo2 = _this.props.popoverContext,
            setPopoverAnchor = _this$props$popoverCo2.setPopoverAnchor,
            setPopoverContent = _this$props$popoverCo2.setPopoverContent; // Set popover anchor

        var cellAnchorEl = _this.popoverAnchorRef.current;
        setPopoverAnchor(cellAnchorEl); // Set popover contents with cell content

        var _this$props6 = _this.props,
            renderCellPopover = _this$props6.renderCellPopover,
            renderCellValue = _this$props6.renderCellValue,
            rowIndex = _this$props6.rowIndex,
            colIndex = _this$props6.colIndex,
            column = _this$props6.column,
            columnId = _this$props6.columnId,
            columnType = _this$props6.columnType;
        var PopoverElement = renderCellPopover || _data_grid_cell_popover.DefaultCellPopover;
        var CellElement = renderCellValue;
        var sharedProps = {
          rowIndex: rowIndex,
          colIndex: colIndex,
          columnId: columnId,
          schema: (column === null || column === void 0 ? void 0 : column.schema) || columnType
        };
        var popoverContent = (0, _react2.jsx)(PopoverElement, (0, _extends2.default)({}, sharedProps, {
          cellContentsElement: _this.cellContentsRef,
          cellActions: (0, _react2.jsx)(_data_grid_cell_actions.EuiDataGridCellPopoverActions, (0, _extends2.default)({}, sharedProps, {
            column: column
          })),
          DefaultCellPopover: _data_grid_cell_popover.DefaultCellPopover
        }), (0, _react2.jsx)(CellElement, (0, _extends2.default)({}, sharedProps, {
          setCellProps: _this.setCellProps,
          isExpandable: true,
          isExpanded: true,
          isDetails: true
        })));
        setPopoverContent(popoverContent);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiDataGridCell, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props7 = this.props,
          colIndex = _this$props7.colIndex,
          visibleRowIndex = _this$props7.visibleRowIndex;
      this.unsubscribeCell = this.context.onFocusUpdate([colIndex, visibleRowIndex], this.onFocusUpdate); // Account for virtualization - when a cell unmounts when scrolled out of view
      // and then remounts when scrolled back into view, it should retain focus state

      if (this.isFocusedCell()) {
        // The second flag sets preventScroll: true as a focus option, which prevents
        // hijacking the user's scroll behavior when the cell re-mounts on scroll
        this.onFocusUpdate(true, true);
        this.context.setIsFocusedCellInView(true);
      } // Check if popover should be open on mount (typically only occurs if
      // openCellPopover() is manually called on a location that's out of view)


      this.handleCellPopover();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.clearTimeout(this.focusTimeout);

      if (this.unsubscribeCell) {
        this.unsubscribeCell();
      }

      if (this.isFocusedCell()) {
        this.context.setIsFocusedCellInView(false);
      }

      if (this.isPopoverOpen()) {
        this.props.popoverContext.closeCellPopover();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this$props$rowHeight, _prevProps$rowHeights;

      this.recalculateAutoHeight();

      if (((_this$props$rowHeight = this.props.rowHeightsOptions) === null || _this$props$rowHeight === void 0 ? void 0 : _this$props$rowHeight.defaultHeight) !== ((_prevProps$rowHeights = prevProps.rowHeightsOptions) === null || _prevProps$rowHeights === void 0 ? void 0 : _prevProps$rowHeights.defaultHeight)) {
        this.recalculateLineHeight();
      }

      if (this.props.popoverContext.popoverIsOpen !== prevProps.popoverContext.popoverIsOpen || this.props.popoverContext.cellLocation !== prevProps.popoverContext.cellLocation || this.props.renderCellPopover !== prevProps.renderCellPopover) {
        this.handleCellPopover();
      }

      if (this.props.columnId !== prevProps.columnId || this.props.rowIndex !== prevProps.rowIndex) {
        this.setCellProps({});
      }
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps, nextState) {
      if (nextProps.rowIndex !== this.props.rowIndex) return true;
      if (nextProps.visibleRowIndex !== this.props.visibleRowIndex) return true;
      if (nextProps.colIndex !== this.props.colIndex) return true;
      if (nextProps.columnId !== this.props.columnId) return true;
      if (nextProps.columnType !== this.props.columnType) return true;
      if (nextProps.width !== this.props.width) return true;
      if (nextProps.rowHeightsOptions !== this.props.rowHeightsOptions) return true;
      if (nextProps.renderCellValue !== this.props.renderCellValue) return true;
      if (nextProps.renderCellPopover !== this.props.renderCellPopover) return true;
      if (nextProps.interactiveCellId !== this.props.interactiveCellId) return true;
      if (nextProps.popoverContext.popoverIsOpen !== this.props.popoverContext.popoverIsOpen || nextProps.popoverContext.cellLocation !== this.props.popoverContext.cellLocation) return true; // respond to adjusted position & dimensions

      if (nextProps.style) {
        if (!this.props.style) return true;

        if (nextProps.style.top !== this.props.style.top) {
          return true;
        }

        if (nextProps.style.left !== this.props.style.left) return true;
        if (nextProps.style.height !== this.props.style.height) return true;
        if (nextProps.style.width !== this.props.style.width) return true;
      }

      if (nextState.cellProps !== this.state.cellProps) return true;
      if (nextState.isEntered !== this.state.isEntered) return true;
      if (nextState.isFocused !== this.state.isFocused) return true;
      if (nextState.enableInteractions !== this.state.enableInteractions) return true;
      if (nextState.disableCellTabIndex !== this.state.disableCellTabIndex) return true;
      return false;
    }
  }, {
    key: "render",
    value: function render() {
      var _classNames,
          _rowHeightsOptions$li,
          _this2 = this;

      var _this$props8 = this.props,
          width = _this$props8.width,
          _this$props8$popoverC = _this$props8.popoverContext,
          closeCellPopover = _this$props8$popoverC.closeCellPopover,
          openCellPopover = _this$props8$popoverC.openCellPopover,
          interactiveCellId = _this$props8.interactiveCellId,
          columnType = _this$props8.columnType,
          className = _this$props8.className,
          column = _this$props8.column,
          style = _this$props8.style,
          rowHeightUtils = _this$props8.rowHeightUtils,
          rowHeightsOptions = _this$props8.rowHeightsOptions,
          rowManager = _this$props8.rowManager,
          rest = (0, _objectWithoutProperties2.default)(_this$props8, ["width", "popoverContext", "interactiveCellId", "columnType", "className", "column", "style", "rowHeightUtils", "rowHeightsOptions", "rowManager"]);
      var rowIndex = rest.rowIndex,
          visibleRowIndex = rest.visibleRowIndex,
          colIndex = rest.colIndex;
      var isExpandable = this.isExpandable();
      var popoverIsOpen = this.isPopoverOpen();
      var showCellActions = this.state.isFocused || this.state.isEntered || this.state.enableInteractions || popoverIsOpen;
      var cellClasses = (0, _classnames.default)('euiDataGridRowCell', (_classNames = {}, (0, _defineProperty2.default)(_classNames, "euiDataGridRowCell--".concat(columnType), columnType), (0, _defineProperty2.default)(_classNames, 'euiDataGridRowCell--open', popoverIsOpen), _classNames), className);
      var _this$state$cellProps2 = this.state.cellProps,
          _ = _this$state$cellProps2.isExpandable,
          cellPropsStyle = _this$state$cellProps2.style,
          cellPropsClassName = _this$state$cellProps2.className,
          cellPropsDataTestSubj = _this$state$cellProps2['data-test-subj'],
          setCellProps = (0, _objectWithoutProperties2.default)(_this$state$cellProps2, ["isExpandable", "style", "className", "data-test-subj"]);

      var cellProps = _objectSpread(_objectSpread({}, setCellProps), {}, {
        'data-test-subj': (0, _classnames.default)('dataGridRowCell', cellPropsDataTestSubj),
        className: (0, _classnames.default)(cellClasses, cellPropsClassName)
      });

      cellProps.style = _objectSpread(_objectSpread({}, style), {}, {
        // from react-window
        top: 0,
        // The cell's row will handle top positioning
        width: width,
        // column width, can be undefined
        lineHeight: (_rowHeightsOptions$li = rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.lineHeight) !== null && _rowHeightsOptions$li !== void 0 ? _rowHeightsOptions$li : undefined
      }, cellPropsStyle);

      var handleCellKeyDown = function handleCellKeyDown(event) {
        if (isExpandable) {
          if (popoverIsOpen) {
            return;
          }

          switch (event.key) {
            case _services.keys.ENTER:
            case _services.keys.F2:
              event.preventDefault();
              openCellPopover({
                rowIndex: visibleRowIndex,
                colIndex: colIndex
              });
              break;
          }
        } else {
          if (event.key === _services.keys.ENTER || event.key === _services.keys.F2 || event.key === _services.keys.ESCAPE) {
            var interactables = _this2.getInteractables();

            if (interactables.length >= 2) {
              switch (event.key) {
                case _services.keys.ENTER:
                  // `Enter` only activates the trap
                  if (_this2.state.isEntered === false) {
                    _this2.enableTabbing();

                    _this2.setState({
                      isEntered: true
                    }); // result of this keypress is focus shifts to the first interactive element
                    // and then the browser fires the onClick event because that's how [Enter] works
                    // so we need to prevent that default action otherwise entering the trap triggers the first element


                    event.preventDefault();
                  }

                  break;

                case _services.keys.F2:
                  // toggle interactives' focus trap
                  _this2.setState(function (_ref2) {
                    var isEntered = _ref2.isEntered;

                    if (isEntered) {
                      _this2.preventTabbing();
                    } else {
                      _this2.enableTabbing();
                    }

                    return {
                      isEntered: !isEntered
                    };
                  });

                  break;

                case _services.keys.ESCAPE:
                  // `Escape` only de-activates the trap
                  _this2.preventTabbing();

                  if (_this2.state.isEntered === true) {
                    _this2.setState({
                      isEntered: false
                    });
                  }

                  break;
              }
            }
          }
        }
      };

      var isDefinedHeight = !!(rowHeightUtils === null || rowHeightUtils === void 0 ? void 0 : rowHeightUtils.getRowHeightOption(rowIndex, rowHeightsOptions));

      var cellContentProps = _objectSpread(_objectSpread({}, rest), {}, {
        setCellProps: this.setCellProps,
        column: column,
        columnType: columnType,
        isExpandable: isExpandable,
        isExpanded: popoverIsOpen,
        isDetails: false,
        setCellContentsRef: this.setCellContentsRef,
        rowHeightsOptions: rowHeightsOptions,
        rowHeightUtils: rowHeightUtils,
        isDefinedHeight: isDefinedHeight
      });

      var anchorClass = 'euiDataGridRowCell__expandFlex';
      var expandClass = isDefinedHeight ? 'euiDataGridRowCell__contentByHeight' : 'euiDataGridRowCell__expandContent';
      var innerContent = (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
        disabled: !this.state.isEntered,
        autoFocus: true,
        onDeactivation: function onDeactivation() {
          _this2.setState({
            isEntered: false
          }, _this2.preventTabbing);
        },
        clickOutsideDisables: true
      }, (0, _react2.jsx)("div", {
        className: anchorClass,
        ref: this.popoverAnchorRef
      }, (0, _react2.jsx)("div", {
        className: expandClass
      }, (0, _react2.jsx)(EuiDataGridCellContent, cellContentProps))));

      if (isExpandable) {
        innerContent = (0, _react2.jsx)("div", {
          className: anchorClass,
          ref: this.popoverAnchorRef
        }, (0, _react2.jsx)("div", {
          className: expandClass
        }, (0, _react2.jsx)(EuiDataGridCellContent, cellContentProps)), showCellActions && (0, _react2.jsx)(_data_grid_cell_actions.EuiDataGridCellActions, {
          rowIndex: rowIndex,
          colIndex: colIndex,
          column: column,
          closePopover: closeCellPopover,
          onExpandClick: function onExpandClick() {
            if (popoverIsOpen) {
              closeCellPopover();
            } else {
              openCellPopover({
                rowIndex: visibleRowIndex,
                colIndex: colIndex
              });
            }
          }
        }));
      }

      var content = (0, _react2.jsx)("div", (0, _extends2.default)({
        role: "gridcell",
        tabIndex: this.state.isFocused && !this.state.disableCellTabIndex ? 0 : -1,
        ref: this.cellRef
      }, cellProps, {
        "data-test-subj": "dataGridRowCell" // Data attributes to help target specific cells by either data or current cell location
        ,
        "data-gridcell-column-id": this.props.columnId // Static column ID name, not affected by column order
        ,
        "data-gridcell-column-index": this.props.colIndex // Affected by column reordering
        ,
        "data-gridcell-row-index": this.props.rowIndex // Index from data, not affected by sorting or pagination
        ,
        "data-gridcell-visible-row-index": this.props.visibleRowIndex // Affected by sorting & pagination
        ,
        "data-gridcell-id": "".concat(this.props.colIndex, ",").concat(this.props.rowIndex) // TODO: Deprecate in favor of the above 4 data attrs
        ,
        onKeyDown: handleCellKeyDown,
        onFocus: this.onFocus,
        onMouseEnter: function onMouseEnter() {
          _this2.setState({
            enableInteractions: true
          });
        },
        onMouseLeave: function onMouseLeave() {
          _this2.setState({
            enableInteractions: false
          });
        },
        onBlur: this.onBlur
      }), innerContent);
      return rowManager && !_utils.IS_JEST_ENVIRONMENT ? /*#__PURE__*/(0, _reactDom.createPortal)(content, rowManager.getRow({
        rowIndex: rowIndex,
        visibleRowIndex: visibleRowIndex,
        top: style.top,
        // comes in as a `{float}px` string from react-window
        height: style.height // comes in as an integer from react-window

      })) : content;
    }
  }]);
  return EuiDataGridCell;
}(_react.Component);

exports.EuiDataGridCell = EuiDataGridCell;
(0, _defineProperty2.default)(EuiDataGridCell, "activeFocusTimeoutId", undefined);
(0, _defineProperty2.default)(EuiDataGridCell, "contextType", _focus.DataGridFocusContext);