/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import PropTypes from "prop-types";
import { EuiI18n, useEuiI18n } from '../../../i18n';
import { EuiTabbedContent } from '../../../tabs';
import { EuiText } from '../../../text';
import { EuiButton } from '../../../button';
import { EuiAbsoluteTab } from './absolute_tab';
import { EuiRelativeTab } from './relative_tab';
import { getDateMode, DATE_MODES, toAbsoluteString, toRelativeString } from '../date_modes';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDatePopoverContent = function EuiDatePopoverContent(_ref) {
  var value = _ref.value,
      _ref$roundUp = _ref.roundUp,
      roundUp = _ref$roundUp === void 0 ? false : _ref$roundUp,
      onChange = _ref.onChange,
      dateFormat = _ref.dateFormat,
      timeFormat = _ref.timeFormat,
      locale = _ref.locale,
      position = _ref.position,
      utcOffset = _ref.utcOffset,
      timeOptions = _ref.timeOptions;

  var onTabClick = function onTabClick(selectedTab) {
    switch (selectedTab.id) {
      case DATE_MODES.ABSOLUTE:
        onChange(toAbsoluteString(value, roundUp));
        break;

      case DATE_MODES.RELATIVE:
        onChange(toRelativeString(value));
        break;
    }
  };

  var startDateLabel = useEuiI18n('euiDatePopoverContent.startDateLabel', 'Start date');
  var endDateLabel = useEuiI18n('euiDatePopoverContent.endDateLabel', 'End date');
  var labelPrefix = position === 'start' ? startDateLabel : endDateLabel;
  var absoluteLabel = useEuiI18n('euiDatePopoverContent.absoluteTabLabel', 'Absolute');
  var relativeLabel = useEuiI18n('euiDatePopoverContent.relativeTabLabel', 'Relative');
  var nowLabel = useEuiI18n('euiDatePopoverContent.nowTabLabel', 'Now');
  var renderTabs = [{
    id: DATE_MODES.ABSOLUTE,
    name: absoluteLabel,
    content: ___EmotionJSX(EuiAbsoluteTab, {
      dateFormat: dateFormat,
      timeFormat: timeFormat,
      locale: locale,
      value: value,
      onChange: onChange,
      roundUp: roundUp,
      position: position,
      labelPrefix: labelPrefix,
      utcOffset: utcOffset
    }),
    'data-test-subj': 'superDatePickerAbsoluteTab',
    'aria-label': "".concat(labelPrefix, ": ").concat(absoluteLabel)
  }, {
    id: DATE_MODES.RELATIVE,
    name: relativeLabel,
    content: ___EmotionJSX(EuiRelativeTab, {
      dateFormat: dateFormat,
      locale: locale,
      value: toAbsoluteString(value, roundUp),
      onChange: onChange,
      roundUp: roundUp,
      position: position,
      labelPrefix: labelPrefix,
      timeOptions: timeOptions
    }),
    'data-test-subj': 'superDatePickerRelativeTab',
    'aria-label': "".concat(labelPrefix, ": ").concat(relativeLabel)
  }, {
    id: DATE_MODES.NOW,
    name: nowLabel,
    content: ___EmotionJSX(EuiText, {
      size: "s",
      color: "subdued",
      className: "euiDatePopoverContent__padded--large"
    }, ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
      token: "euiDatePopoverContent.nowTabContent",
      default: "Setting the time to \"now\" means that on every refresh this time will be set to the time of the refresh."
    })), ___EmotionJSX(EuiButton, {
      "data-test-subj": "superDatePickerNowButton",
      onClick: function onClick() {
        onChange('now');
      },
      fullWidth: true,
      size: "s",
      fill: true
    }, position === 'start' ? ___EmotionJSX(EuiI18n, {
      token: "euiDatePopoverContent.nowTabButtonStart",
      default: "Set start date and time to now"
    }) : ___EmotionJSX(EuiI18n, {
      token: "euiDatePopoverContent.nowTabButtonEnd",
      default: "Set end date and time to now"
    }))),
    'data-test-subj': 'superDatePickerNowTab',
    'aria-label': "".concat(labelPrefix, ": ").concat(nowLabel)
  }];
  var initialSelectedTab = renderTabs.find(function (tab) {
    return tab.id === getDateMode(value);
  });
  return ___EmotionJSX(EuiTabbedContent, {
    className: "euiDatePopoverContent",
    tabs: renderTabs,
    autoFocus: "selected",
    initialSelectedTab: initialSelectedTab,
    onTabClick: onTabClick,
    size: "s",
    expand: true
  });
};
EuiDatePopoverContent.propTypes = {
  value: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  roundUp: PropTypes.bool,
  dateFormat: PropTypes.string.isRequired,
  timeFormat: PropTypes.string.isRequired,
  locale: PropTypes.any,
  position: PropTypes.oneOf(["start", "end"]).isRequired,
  utcOffset: PropTypes.number,
  timeOptions: PropTypes.shape({
    timeTenseOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    timeUnitsOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    relativeOptions: PropTypes.arrayOf(PropTypes.shape({
      text: PropTypes.string.isRequired,
      value: PropTypes.oneOfType([PropTypes.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, PropTypes.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: PropTypes.any.isRequired,
    refreshUnitsOptions: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
    commonDurationRanges: PropTypes.arrayOf(PropTypes.shape({
      end: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired,
      label: PropTypes.string,
      start: PropTypes.oneOfType([PropTypes.oneOf(["now"]), PropTypes.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired
};
EuiDatePopoverContent.displayName = 'EuiDatePopoverContent';