"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getExternalTooltipType = exports.getShowNullValues = exports.getTooltipType = exports.isFollowTooltipType = exports.isCrosshairTooltipType = exports.isTooltipType = exports.isTooltipProps = exports.isPointerOverEvent = exports.isPointerOutEvent = exports.Settings = void 0;
var spec_factory_1 = require("../state/spec_factory");
var common_1 = require("../utils/common");
var constants_1 = require("./constants");
var Settings = function (props) {
    var defaults = constants_1.settingsBuildProps.defaults, overrides = constants_1.settingsBuildProps.overrides;
    (0, spec_factory_1.useSpecFactory)(__assign(__assign(__assign({}, defaults), (0, common_1.stripUndefined)(props)), overrides));
    return null;
};
exports.Settings = Settings;
function isPointerOutEvent(event) {
    return (event === null || event === void 0 ? void 0 : event.type) === constants_1.PointerEventType.Out;
}
exports.isPointerOutEvent = isPointerOutEvent;
function isPointerOverEvent(event) {
    return (event === null || event === void 0 ? void 0 : event.type) === constants_1.PointerEventType.Over;
}
exports.isPointerOverEvent = isPointerOverEvent;
function isTooltipProps(config) {
    return typeof config === 'object';
}
exports.isTooltipProps = isTooltipProps;
function isTooltipType(config) {
    return typeof config !== 'object';
}
exports.isTooltipType = isTooltipType;
function isCrosshairTooltipType(type) {
    return type === constants_1.TooltipType.VerticalCursor || type === constants_1.TooltipType.Crosshairs;
}
exports.isCrosshairTooltipType = isCrosshairTooltipType;
function isFollowTooltipType(type) {
    return type === constants_1.TooltipType.Follow;
}
exports.isFollowTooltipType = isFollowTooltipType;
function getTooltipType(settings, externalTooltip) {
    if (externalTooltip === void 0) { externalTooltip = false; }
    var defaultType = constants_1.TooltipType.VerticalCursor;
    if (externalTooltip)
        return getExternalTooltipType(settings);
    var tooltip = settings.tooltip;
    if (tooltip === undefined || tooltip === null)
        return defaultType;
    if (isTooltipType(tooltip))
        return tooltip;
    if (isTooltipProps(tooltip))
        return tooltip.type || defaultType;
    return defaultType;
}
exports.getTooltipType = getTooltipType;
function getShowNullValues(settings) {
    var _a;
    var tooltip = settings.tooltip;
    if (tooltip === undefined || tooltip === null)
        return constants_1.DEFAULT_TOOLTIP_CONFIG.showNullValues;
    if (isTooltipType(tooltip))
        return constants_1.DEFAULT_TOOLTIP_CONFIG.showNullValues;
    if (isTooltipProps(tooltip))
        return (_a = tooltip.showNullValues) !== null && _a !== void 0 ? _a : constants_1.DEFAULT_TOOLTIP_CONFIG.showNullValues;
}
exports.getShowNullValues = getShowNullValues;
function getExternalTooltipType(_a) {
    var visible = _a.externalPointerEvents.tooltip.visible;
    return visible ? constants_1.TooltipType.VerticalCursor : constants_1.TooltipType.None;
}
exports.getExternalTooltipType = getExternalTooltipType;
//# sourceMappingURL=settings.js.map