React to availability issues across your apps and services before they affect users.

While a service being "up" or "down" might seem binary, the data surrounding each data point isn't. Give your team the context they need to go well beyond status codes. With Elastic Uptime, powered by open source [Heartbeat](https://www.elastic.co/beats/heartbeat), your availability data works in concert with rich context provided by [logs](https://www.elastic.co/log-monitoring), [metrics](https://www.elastic.co/infrastructure-monitoring), and [APM](https://www.elastic.co/apm) — making it simpler to connect the dots, correlate activity, and solve problems quickly.

Organizations need to track the performance and availability of a rapidly expanding list of components and services. Investigating the inevitable question, "Is X down?" is streamlined with Elastic Uptime. Active monitoring with [custom alerting options](https://www.elastic.co/what-is/kibana-alerting) keeps you ahead of your users — ensuring they have a positive, issue-free experience.

Supports availability ping monitoring of HTTP, TCP, and ICMP endpoints and functionality, as well as performance monitoring of full webpages or scripted user journeys.

Elastic Synthetics monitoring is included with all license levels via the Uptime app in Observability. In this release, you will need to set up your own synthetic testing nodes to execute your tests. For step by step instructions on how to set up a synthetic testing node for Elastic Synthetics with Elastic Agent, see the [Quick Start Guide](https://www.elastic.co/guide/en/observability/current/synthetics-quickstart-fleet.html). Hosted testing locations will be coming in a future release.