"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  restApiRoutes: true,
  createRouteWithAuth: true,
  uptimeRouteWrapper: true
};
Object.defineProperty(exports, "createRouteWithAuth", {
  enumerable: true,
  get: function () {
    return _create_route_with_auth.createRouteWithAuth;
  }
});
exports.restApiRoutes = void 0;
Object.defineProperty(exports, "uptimeRouteWrapper", {
  enumerable: true,
  get: function () {
    return _uptime_route_wrapper.uptimeRouteWrapper;
  }
});

var _pings = require("./pings");

var _dynamic_settings = require("./dynamic_settings");

var _telemetry = require("./telemetry");

var _snapshot = require("./snapshot");

var _monitors = require("./monitors");

var _monitors_durations = require("./monitors/monitors_durations");

var _index_state = require("./index_state");

var _network_events = require("./network_events");

var _journeys = require("./pings/journeys");

var _last_successful_check = require("./synthetics/last_successful_check");

var _install_index_templates = require("./synthetics_service/install_index_templates");

var _get_service_locations = require("./synthetics_service/get_service_locations");

var _get_monitor = require("./synthetics_service/get_monitor");

var _add_monitor = require("./synthetics_service/add_monitor");

var _edit_monitor = require("./synthetics_service/edit_monitor");

var _delete_monitor = require("./synthetics_service/delete_monitor");

var _run_once_monitor = require("./synthetics_service/run_once_monitor");

var _test_now_monitor = require("./synthetics_service/test_now_monitor");

var _enablement = require("./synthetics_service/enablement");

var _get_service_allowed = require("./synthetics_service/get_service_allowed");

var _types = require("./types");

Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});

var _create_route_with_auth = require("./create_route_with_auth");

var _uptime_route_wrapper = require("./uptime_route_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const restApiRoutes = [_add_monitor.addSyntheticsMonitorRoute, _enablement.getSyntheticsEnablementRoute, _pings.createGetPingsRoute, _index_state.createGetIndexStatusRoute, _dynamic_settings.createGetDynamicSettingsRoute, _dynamic_settings.createPostDynamicSettingsRoute, _monitors.createGetMonitorDetailsRoute, _monitors.createGetMonitorLocationsRoute, _monitors.createMonitorListRoute, _monitors.createGetStatusBarRoute, _snapshot.createGetSnapshotCount, _telemetry.createLogPageViewRoute, _pings.createGetPingHistogramRoute, _monitors_durations.createGetMonitorDurationRoute, _pings.createJourneyRoute, _pings.createJourneyScreenshotRoute, _network_events.createNetworkEventsRoute, _journeys.createJourneyFailedStepsRoute, _last_successful_check.createLastSuccessfulCheckRoute, _pings.createJourneyScreenshotBlocksRoute, _delete_monitor.deleteSyntheticsMonitorRoute, _enablement.disableSyntheticsRoute, _edit_monitor.editSyntheticsMonitorRoute, _enablement.enableSyntheticsRoute, _get_service_locations.getServiceLocationsRoute, _get_monitor.getSyntheticsMonitorRoute, _get_monitor.getAllSyntheticsMonitorRoute, _install_index_templates.installIndexTemplatesRoute, _run_once_monitor.runOnceSyntheticsMonitorRoute, _test_now_monitor.testNowMonitorRoute, _get_service_allowed.getServiceAllowedRoute];
exports.restApiRoutes = restApiRoutes;